/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.api.db.impl;

import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import xyz.tcheeric.cashu.vault.api.DBVault;
import xyz.tcheeric.cashu.vault.api.VaultClientFactory;
import xyz.tcheeric.cashu.vault.db.client.ProofClient;
import xyz.tcheeric.cashu.vault.db.client.VaultClient;
import xyz.tcheeric.cashu.vault.db.model.BaseEntity;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;

public class DBProofVault
extends DBVault<ProofEntity> {
    @Generated
    private static final Logger log = Logger.getLogger(DBProofVault.class.getName());
    private static final ReentrantLock PROOF_STATE_LOCK = new ReentrantLock();

    public DBProofVault() {
        this(VaultClientFactory.getClient(ProofEntity.class));
    }

    public DBProofVault(VaultClient<ProofEntity> client) {
        super(client);
    }

    @Override
    public ProofEntity store(ProofEntity proofEntity) {
        proofEntity.setMint(this.getMint(proofEntity));
        return (ProofEntity)this.client.store((BaseEntity)proofEntity);
    }

    @Override
    protected ProofEntity retrieveEntity(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return (ProofEntity)this.client.retrieve(id);
    }

    public static ProofEntity retrieveProof(@NonNull String secret) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        ProofClient client = VaultClientFactory.proofClient();
        return DBProofVault.retrieveProof(secret, client);
    }

    public static ProofEntity retrieveProof(@NonNull String secret, ProofClient client) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        return client.getBySecret(secret);
    }

    public static ProofEntity retrieveProof(@NonNull String mintId, @NonNull String secret) {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        ProofClient client = VaultClientFactory.proofClient();
        return DBProofVault.retrieveProof(mintId, secret, client);
    }

    public static ProofEntity retrieveProof(@NonNull String mintId, @NonNull String secret, ProofClient client) {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        return client.getByMintIdAndSecret(mintId, secret);
    }

    public static ProofEntity retrieveProof(String mintId, Integer amount) {
        ProofClient client = VaultClientFactory.proofClient();
        return DBProofVault.retrieveProof(mintId, amount, client);
    }

    public static ProofEntity retrieveProof(String mintId, Integer amount, ProofClient client) {
        return client.getByMintAndAmount(mintId, amount);
    }

    public static ProofEntity retrieveProofByUnblindedSignature(@NonNull String mintId, @NonNull String unblindedSignature) {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (unblindedSignature == null) {
            throw new NullPointerException("unblindedSignature is marked non-null but is null");
        }
        ProofClient client = new ProofClient();
        return client.getByMintAndUnblindedSignature(mintId, unblindedSignature);
    }

    public ProofEntity storePending(@NonNull ProofEntity proofEntity) {
        if (proofEntity == null) {
            throw new NullPointerException("proofEntity is marked non-null but is null");
        }
        VaultClient<ProofEntity> client = VaultClientFactory.getClient(ProofEntity.class);
        proofEntity.setMint(this.getMint(proofEntity));
        proofEntity.setState("PENDING");
        return (ProofEntity)client.store((BaseEntity)proofEntity);
    }

    private MintEntity getMint(ProofEntity proofEntity) {
        VaultClient<MintEntity> mintVaultClient = VaultClientFactory.getClient(MintEntity.class);
        return (MintEntity)mintVaultClient.retrieve(proofEntity.getMint().getId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProofEntity archive(String id) {
        PROOF_STATE_LOCK.lock();
        try {
            ProofClient proofClient = VaultClientFactory.proofClient();
            ProofEntity proofEntity = this.retrieveEntity(id);
            proofEntity.setArchived(true);
            proofClient.store((BaseEntity)proofEntity);
            ProofEntity proofEntity2 = proofEntity;
            return proofEntity2;
        }
        finally {
            PROOF_STATE_LOCK.unlock();
        }
    }

    @Override
    public void delete(String id) {
        ProofClient client = VaultClientFactory.proofClient();
        client.delete(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProofEntity invalidate(String id) {
        PROOF_STATE_LOCK.lock();
        try {
            ProofClient proofClient = VaultClientFactory.proofClient();
            ProofEntity proofEntity = this.retrieveEntity(id);
            proofEntity.setState("SPENT");
            proofClient.store((BaseEntity)proofEntity);
            ProofEntity proofEntity2 = proofEntity;
            return proofEntity2;
        }
        finally {
            PROOF_STATE_LOCK.unlock();
        }
    }
}

