/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.tcheeric.cashu.vault.db.client.KeySetVaultClient;
import xyz.tcheeric.cashu.vault.db.client.KeyVaultClient;
import xyz.tcheeric.cashu.vault.db.client.ProofClient;
import xyz.tcheeric.cashu.vault.db.client.VaultClient;
import xyz.tcheeric.cashu.vault.db.config.VaultBaseProperties;
import xyz.tcheeric.cashu.vault.db.model.BaseEntity;

public final class VaultClientFactory {
    private static final VaultBaseProperties PROPERTIES = new VaultBaseProperties();
    private static final Map<Class<?>, VaultClient<?>> CLIENTS = new ConcurrentHashMap();
    private static final KeySetVaultClient KEY_SET_CLIENT = new KeySetVaultClient();
    private static final KeyVaultClient KEY_CLIENT;
    private static final ProofClient PROOF_CLIENT;

    private VaultClientFactory() {
    }

    public static <T extends BaseEntity> VaultClient<T> getClient(Class<T> type) {
        return CLIENTS.computeIfAbsent(type, t -> new VaultClient(type, PROPERTIES.getUrl()));
    }

    public static KeySetVaultClient keySetClient() {
        return KEY_SET_CLIENT;
    }

    public static KeyVaultClient keyClient() {
        return KEY_CLIENT;
    }

    public static ProofClient proofClient() {
        return PROOF_CLIENT;
    }

    static {
        KEY_SET_CLIENT.setBaseUrl(PROPERTIES.getUrl());
        KEY_CLIENT = new KeyVaultClient();
        KEY_CLIENT.setBaseUrl(PROPERTIES.getUrl());
        PROOF_CLIENT = new ProofClient();
        PROOF_CLIENT.setBaseUrl(PROPERTIES.getUrl());
    }
}

