/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.api.db.impl;

import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.vault.api.DBVault;
import xyz.tcheeric.cashu.vault.api.VaultClientFactory;
import xyz.tcheeric.cashu.vault.db.client.ProofClient;
import xyz.tcheeric.cashu.vault.db.client.VaultClient;
import xyz.tcheeric.cashu.vault.db.model.BaseEntity;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;

public class DBProofVault
extends DBVault<ProofEntity> {
    @Generated
    private static final Logger log = Logger.getLogger(DBProofVault.class.getName());
    private static final ReentrantLock PROOF_STATE_LOCK = new ReentrantLock();

    public DBProofVault() {
        this(VaultClientFactory.getClient(ProofEntity.class));
    }

    public DBProofVault(VaultClient<ProofEntity> client) {
        super(client);
    }

    @Override
    public ProofEntity store(ProofEntity proofEntity) throws CashuErrorException {
        proofEntity.setMint(this.getMint(proofEntity));
        return (ProofEntity)this.client.store((BaseEntity)proofEntity);
    }

    @Override
    protected ProofEntity retrieveEntity(@NonNull String id) throws CashuErrorException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        ProofEntity proofEntity = (ProofEntity)this.client.retrieve(id);
        if (proofEntity == null) {
            throw new CashuErrorException("Proof not found");
        }
        return proofEntity;
    }

    public static ProofEntity retrieveProof(@NonNull String secret) throws CashuErrorException {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        ProofClient client = VaultClientFactory.proofClient();
        return DBProofVault.retrieveProof(secret, client);
    }

    public static ProofEntity retrieveProof(@NonNull String secret, ProofClient client) throws CashuErrorException {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        ProofEntity proofEntity = client.getBySecret(secret);
        return proofEntity;
    }

    public static ProofEntity retrieveProof(@NonNull String mintId, @NonNull String secret) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        ProofClient client = VaultClientFactory.proofClient();
        return DBProofVault.retrieveProof(mintId, secret, client);
    }

    public static ProofEntity retrieveProof(@NonNull String mintId, @NonNull String secret, ProofClient client) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        ProofEntity proofEntity = client.getByMintIdAndSecret(mintId, secret);
        return proofEntity;
    }

    public static ProofEntity retrieveProof(String mintId, Integer amount) throws CashuErrorException {
        ProofClient client = VaultClientFactory.proofClient();
        return DBProofVault.retrieveProof(mintId, amount, client);
    }

    public static ProofEntity retrieveProof(String mintId, Integer amount, ProofClient client) throws CashuErrorException {
        ProofEntity proofEntity = client.getByMintAndAmount(mintId, amount);
        return proofEntity;
    }

    public static ProofEntity retrieveProofByUnblindedSignature(@NonNull String mintId, @NonNull String unblindedSignature) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (unblindedSignature == null) {
            throw new NullPointerException("unblindedSignature is marked non-null but is null");
        }
        ProofClient client = new ProofClient();
        ProofEntity proofEntity = client.getByMintAndUnblindedSignature(mintId, unblindedSignature);
        return proofEntity;
    }

    public ProofEntity storePending(@NonNull ProofEntity proofEntity) throws CashuErrorException {
        if (proofEntity == null) {
            throw new NullPointerException("proofEntity is marked non-null but is null");
        }
        VaultClient<ProofEntity> client = VaultClientFactory.getClient(ProofEntity.class);
        proofEntity.setMint(this.getMint(proofEntity));
        proofEntity.setState("PENDING");
        return (ProofEntity)client.store((BaseEntity)proofEntity);
    }

    private MintEntity getMint(ProofEntity proofEntity) {
        VaultClient<MintEntity> mintVaultClient = VaultClientFactory.getClient(MintEntity.class);
        return (MintEntity)mintVaultClient.retrieve(proofEntity.getMint().getId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProofEntity archive(String id) throws CashuErrorException {
        PROOF_STATE_LOCK.lock();
        try {
            ProofClient proofClient = VaultClientFactory.proofClient();
            ProofEntity proofEntity = this.retrieveEntity(id);
            proofEntity.setArchived(true);
            proofClient.store((BaseEntity)proofEntity);
            ProofEntity proofEntity2 = proofEntity;
            return proofEntity2;
        }
        finally {
            PROOF_STATE_LOCK.unlock();
        }
    }

    @Override
    public void delete(String id) throws CashuErrorException {
        ProofClient client = VaultClientFactory.proofClient();
        client.delete(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProofEntity invalidate(String id) throws CashuErrorException {
        PROOF_STATE_LOCK.lock();
        try {
            ProofClient proofClient = VaultClientFactory.proofClient();
            ProofEntity proofEntity = this.retrieveEntity(id);
            proofEntity.setState("SPENT");
            proofClient.store((BaseEntity)proofEntity);
            ProofEntity proofEntity2 = proofEntity;
            return proofEntity2;
        }
        finally {
            PROOF_STATE_LOCK.unlock();
        }
    }
}

