/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.controller;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.vault.db.model.KeyEntity;
import xyz.tcheeric.cashu.vault.db.repos.KeyRepository;

@RestController
@RequestMapping(value={"/vault/key"})
public class KeyVaultController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyVaultController.class);
    private final KeyRepository keyRepository;

    @PostMapping
    public ResponseEntity<KeyEntity> store(@RequestBody KeyEntity key) throws CashuErrorException {
        log.info("Storing KeyEntity {}", (Object)key.getId());
        KeyEntity savedKey = (KeyEntity)this.keyRepository.save(key);
        log.debug("Stored KeyEntity {}", (Object)savedKey.getId());
        return ResponseEntity.ok((Object)savedKey);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<KeyEntity> retrieve(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Retrieving KeyEntity {}", (Object)id);
        Optional keyOpt = this.keyRepository.findById(UUID.fromString(id));
        if (keyOpt.isPresent()) {
            log.debug("Retrieved KeyEntity {}", (Object)((KeyEntity)keyOpt.get()).getId());
            return ResponseEntity.ok((Object)((KeyEntity)keyOpt.get()));
        }
        throw new CashuErrorException("KeyEntity not found");
    }

    @GetMapping(value={"/unit/{unit}"})
    public ResponseEntity<Set<KeyEntity>> getKeysByUnit(@PathVariable(value="unit") String unit) throws CashuErrorException {
        log.info("Retrieving keys for unit {}", (Object)unit);
        Set keySet = this.keyRepository.findByKeySet_UnitIgnoreCase(unit).filter(set -> !set.isEmpty()).orElseThrow(() -> new CashuErrorException("No keys found for the specified unit"));
        return ResponseEntity.ok((Object)keySet);
    }

    @GetMapping(value={"/privatekey/{privateKey}"})
    public ResponseEntity<KeyEntity> getKeyByPrivateKey(@PathVariable(value="privateKey") String privateKey) throws CashuErrorException {
        log.info("Retrieving KeyEntity by private key");
        Optional<KeyEntity> keyOpt = this.keyRepository.findByPrivateKey(privateKey);
        if (keyOpt.isPresent()) {
            log.debug("Retrieved KeyEntity {}", (Object)keyOpt.get().getId());
            return ResponseEntity.ok((Object)keyOpt.get());
        }
        throw new CashuErrorException("KeyEntity not found for the specified private key");
    }

    @GetMapping(value={"/keyset/{id}"})
    public ResponseEntity<Set<KeyEntity>> getKeysByKeySetId(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Retrieving keys for keySet {}", (Object)id);
        Optional<Set<KeyEntity>> keys = this.keyRepository.findByKeySet_Id(UUID.fromString(id));
        if (keys.isPresent()) {
            return ResponseEntity.ok(keys.get());
        }
        throw new CashuErrorException("No keys found for the specified key set ID");
    }

    @PostMapping(value={"/archive/{id}"})
    public ResponseEntity<KeyEntity> archive(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Archiving KeyEntity {}", (Object)id);
        Optional keyOpt = this.keyRepository.findById(UUID.fromString(id));
        if (keyOpt.isPresent()) {
            KeyEntity archivedKey = (KeyEntity)keyOpt.get();
            archivedKey.setArchived(true);
            KeyEntity updatedKey = (KeyEntity)this.keyRepository.save(archivedKey);
            log.debug("Archived KeyEntity {}", (Object)updatedKey.getId());
            return ResponseEntity.ok((Object)updatedKey);
        }
        throw new CashuErrorException("KeyEntity not found");
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Deleting KeyEntity {}", (Object)id);
        Optional keyOpt = this.keyRepository.findById(UUID.fromString(id));
        if (keyOpt.isPresent()) {
            this.keyRepository.delete((KeyEntity)keyOpt.get());
            log.debug("Deleted KeyEntity {}", (Object)((KeyEntity)keyOpt.get()).getId());
            return ResponseEntity.noContent().build();
        }
        throw new CashuErrorException("KeyEntity not found");
    }

    @Generated
    public KeyVaultController(KeyRepository keyRepository) {
        this.keyRepository = keyRepository;
    }
}

