/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.controller;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;
import xyz.tcheeric.cashu.vault.db.repos.MintRepository;

@RequestMapping(value={"/vault/mint"})
@RestController
public class MintVaultController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintVaultController.class);
    private final MintRepository mintRepository;

    @PostMapping
    public ResponseEntity<MintEntity> store(@RequestBody MintEntity mint) throws CashuErrorException {
        log.info("Storing MintEntity {}", (Object)mint.getId());
        MintEntity newMint = (MintEntity)this.mintRepository.save(mint);
        log.debug("Stored MintEntity {}", (Object)newMint.getId());
        return ResponseEntity.ok((Object)newMint);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<MintEntity> retrieve(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Retrieving MintEntity {}", (Object)id);
        MintEntity mint = (MintEntity)this.mintRepository.findById(UUID.fromString(id)).orElseThrow(() -> new CashuErrorException("MintEntity not found"));
        log.debug("Retrieved MintEntity {}", (Object)mint.getId());
        return ResponseEntity.ok((Object)mint);
    }

    @PostMapping(value={"/archive/{id}"})
    public ResponseEntity<MintEntity> archive(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Archiving MintEntity {}", (Object)id);
        MintEntity mint = (MintEntity)this.mintRepository.findById(UUID.fromString(id)).orElseThrow(() -> new CashuErrorException("MintEntity not found"));
        mint.setArchived(true);
        MintEntity archivedMint = (MintEntity)this.mintRepository.save(mint);
        log.debug("Archived MintEntity {}", (Object)archivedMint.getId());
        return ResponseEntity.ok((Object)archivedMint);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Deleting MintEntity {}", (Object)id);
        MintEntity mint = (MintEntity)this.mintRepository.findById(UUID.fromString(id)).orElseThrow(() -> new CashuErrorException("MintEntity not found"));
        this.mintRepository.delete(mint);
        log.debug("Deleted MintEntity {}", (Object)mint.getId());
        return ResponseEntity.noContent().build();
    }

    @ExceptionHandler(value={ObjectOptimisticLockingFailureException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    public String handleOptimisticLockingFailure(ObjectOptimisticLockingFailureException ex) {
        log.warn("Optimistic locking failure", (Throwable)ex);
        return "Conflict detected: " + ex.getMessage();
    }

    @Generated
    public MintVaultController(MintRepository mintRepository) {
        this.mintRepository = mintRepository;
    }
}

