/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.client;

import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import xyz.tcheeric.cashu.vault.db.client.VaultClient;
import xyz.tcheeric.cashu.vault.db.model.KeySetEntity;

public class KeySetVaultClient
extends VaultClient<KeySetEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeySetVaultClient.class);

    public KeySetVaultClient() {
        super(KeySetEntity.class);
    }

    public KeySetEntity getByKeySetId(String keySetId) {
        log.info("GET {}/vault/keyset/id/{}", (Object)this.getBaseUrl(), (Object)keySetId);
        return (KeySetEntity)this.restTemplate.getForObject(this.getBaseUrl() + "/vault/keyset/id/" + keySetId, KeySetEntity.class, new Object[0]);
    }

    public Set<KeySetEntity> getByUnit(String unit) {
        log.info("GET {}/vault/keyset/unit/{}", (Object)this.getBaseUrl(), (Object)unit);
        ResponseEntity response = this.restTemplate.exchange(this.getBaseUrl() + "/vault/keyset/unit/" + unit, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Set<KeySetEntity>>(this){}, new Object[0]);
        Set keySetEntities = (Set)response.getBody();
        if (keySetEntities == null || keySetEntities.isEmpty()) {
            throw new IllegalArgumentException("No KeySet found for unit: " + unit);
        }
        return keySetEntities;
    }

    public Set<KeySetEntity> getByMintId(String mintId) {
        log.info("GET {}/vault/keyset/mint/{}", (Object)this.getBaseUrl(), (Object)mintId);
        ResponseEntity response = this.restTemplate.exchange(this.getBaseUrl() + "/vault/keyset/mint/" + mintId, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Set<KeySetEntity>>(this){}, new Object[0]);
        Set keySetEntities = (Set)response.getBody();
        if (keySetEntities == null || keySetEntities.isEmpty()) {
            throw new IllegalArgumentException("No KeySet found for mintId: " + mintId);
        }
        return keySetEntities;
    }
}

