/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.SecretUtil;
import xyz.tcheeric.cashu.vault.db.model.BaseEntity;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;

@Entity(name="proof")
@Table(name="t_proof", indexes={@Index(name="idx_proof_mint_id", columnList="mint_id")})
@Audited
@AuditTable(value="t_proof_a")
public class ProofEntity
extends BaseEntity {
    public static final String STATE_PENDING = "PENDING";
    public static final String STATE_UNSPENT = "UNSPENT";
    public static final String STATE_SPENT = "SPENT";
    @ManyToOne(cascade={CascadeType.ALL}, optional=false)
    @JoinColumn(name="mint_id", nullable=false)
    @JsonProperty
    private MintEntity mint;
    @JsonProperty
    @Column(name="amount", nullable=false)
    private Integer amount;
    @JsonProperty
    @Column(name="secret", nullable=false)
    private String secret;
    @JsonProperty
    @Column(name="C", nullable=false)
    private String unblindedSignature;
    @JsonProperty
    @Column(name="witness", unique=true)
    private String witness;
    @JsonProperty
    @Column(name="state", nullable=false)
    private String state = "UNSPENT";

    public static <T extends Secret> ProofEntity fromProof(Proof<T> proof, MintEntity mintEntity) {
        ProofEntity proofEntity = new ProofEntity();
        proofEntity.setAmount(proof.getAmount());
        proofEntity.setSecret(SecretUtil.toY((Secret)proof.getSecret()));
        if (proof.getWitness() != null) {
            proofEntity.setWitness(proof.getWitness().toString());
        }
        proofEntity.setUnblindedSignature(proof.getUnblindedSignature().toString());
        proofEntity.setMint(mintEntity);
        return proofEntity;
    }

    @Generated
    public ProofEntity() {
    }

    @Generated
    public MintEntity getMint() {
        return this.mint;
    }

    @Generated
    public Integer getAmount() {
        return this.amount;
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public String getUnblindedSignature() {
        return this.unblindedSignature;
    }

    @Generated
    public String getWitness() {
        return this.witness;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @JsonProperty
    @Generated
    public void setMint(MintEntity mint) {
        this.mint = mint;
    }

    @JsonProperty
    @Generated
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonProperty
    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @JsonProperty
    @Generated
    public void setUnblindedSignature(String unblindedSignature) {
        this.unblindedSignature = unblindedSignature;
    }

    @JsonProperty
    @Generated
    public void setWitness(String witness) {
        this.witness = witness;
    }

    @JsonProperty
    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProofEntity)) {
            return false;
        }
        ProofEntity other = (ProofEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$amount = this.getAmount();
        Integer other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        MintEntity this$mint = this.getMint();
        MintEntity other$mint = other.getMint();
        if (this$mint == null ? other$mint != null : !((Object)this$mint).equals(other$mint)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$unblindedSignature = this.getUnblindedSignature();
        String other$unblindedSignature = other.getUnblindedSignature();
        if (this$unblindedSignature == null ? other$unblindedSignature != null : !this$unblindedSignature.equals(other$unblindedSignature)) {
            return false;
        }
        String this$witness = this.getWitness();
        String other$witness = other.getWitness();
        if (this$witness == null ? other$witness != null : !this$witness.equals(other$witness)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProofEntity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        MintEntity $mint = this.getMint();
        result = result * 59 + ($mint == null ? 43 : ((Object)$mint).hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $unblindedSignature = this.getUnblindedSignature();
        result = result * 59 + ($unblindedSignature == null ? 43 : $unblindedSignature.hashCode());
        String $witness = this.getWitness();
        result = result * 59 + ($witness == null ? 43 : $witness.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ProofEntity(super=" + super.toString() + ", mint=" + String.valueOf(this.getMint()) + ", amount=" + this.getAmount() + ", secret=" + this.getSecret() + ", unblindedSignature=" + this.getUnblindedSignature() + ", witness=" + this.getWitness() + ", state=" + this.getState() + ")";
    }
}

