-- Schema DDL for xyz.tcheeric.cashu.vault.db.model
-- Target: PostgreSQL
-- Generated to mirror Hibernate DDL observed during tests

-- Drop existing tables (order matters due to FKs)
DROP TABLE IF EXISTS t_proof_a CASCADE;
DROP TABLE IF EXISTS t_proof CASCADE;
DROP TABLE IF EXISTS t_key_a CASCADE;
DROP TABLE IF EXISTS t_key CASCADE;
DROP TABLE IF EXISTS t_keyset_a CASCADE;
DROP TABLE IF EXISTS t_keyset CASCADE;
DROP TABLE IF EXISTS t_mint_a CASCADE;
DROP TABLE IF EXISTS t_mint CASCADE;
DROP TABLE IF EXISTS revinfo CASCADE;

-- Envers revision table
CREATE TABLE revinfo (
    rev INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
    revtstmp BIGINT
);

-- Core entity tables ---------------------------------------------------------

-- MintEntity
CREATE TABLE t_mint (
    archived BOOLEAN NOT NULL,
    version INTEGER,
    created_at TIMESTAMP(6) WITH TIME ZONE NOT NULL,
    updated_at TIMESTAMP(6) WITH TIME ZONE NOT NULL,
    id UUID NOT NULL,
    PRIMARY KEY (id)
);

-- KeySetEntity
CREATE TABLE t_keyset (
    archived BOOLEAN NOT NULL,
    version INTEGER,
    unit VARCHAR(5) NOT NULL,
    created_at TIMESTAMP(6) WITH TIME ZONE NOT NULL,
    updated_at TIMESTAMP(6) WITH TIME ZONE NOT NULL,
    id UUID NOT NULL,
    key_set_id VARCHAR(16) NOT NULL,
    mint_id UUID,
    PRIMARY KEY (id),
    CONSTRAINT idx_keyset_unit_mint_unq UNIQUE (unit, mint_id),
    CONSTRAINT idx_keyset_key_set_mint_unq UNIQUE (key_set_id, mint_id)
);

-- KeyEntity
CREATE TABLE t_key (
    amount NUMERIC(38,0) NOT NULL,
    archived BOOLEAN NOT NULL,
    version INTEGER,
    created_at TIMESTAMP(6) WITH TIME ZONE NOT NULL,
    updated_at TIMESTAMP(6) WITH TIME ZONE NOT NULL,
    id UUID NOT NULL,
    key_set_id UUID,
    private_key VARCHAR(255) NOT NULL,
    PRIMARY KEY (id),
    CONSTRAINT idx_key_private_key_unq UNIQUE (private_key)
);

-- ProofEntity
CREATE TABLE t_proof (
    amount INTEGER NOT NULL,
    archived BOOLEAN NOT NULL,
    version INTEGER,
    created_at TIMESTAMP(6) WITH TIME ZONE NOT NULL,
    updated_at TIMESTAMP(6) WITH TIME ZONE NOT NULL,
    id UUID NOT NULL,
    mint_id UUID NOT NULL,
    c VARCHAR(255) NOT NULL,
    secret VARCHAR(255) NOT NULL,
    state VARCHAR(255) NOT NULL,
    witness VARCHAR(255) UNIQUE,
    PRIMARY KEY (id)
);

-- Indexes
CREATE INDEX idx_proof_mint_id ON t_proof (mint_id);

-- Foreign keys for core tables
ALTER TABLE IF EXISTS t_key
    ADD CONSTRAINT fk_key_keyset FOREIGN KEY (key_set_id) REFERENCES t_keyset;

ALTER TABLE IF EXISTS t_keyset
    ADD CONSTRAINT fk_keyset_mint FOREIGN KEY (mint_id) REFERENCES t_mint;

ALTER TABLE IF EXISTS t_proof
    ADD CONSTRAINT fk_proof_mint FOREIGN KEY (mint_id) REFERENCES t_mint;

-- Envers audit tables --------------------------------------------------------

-- MintEntity audit
CREATE TABLE t_mint_a (
    archived BOOLEAN,
    rev INTEGER NOT NULL,
    revtype SMALLINT,
    created_at TIMESTAMP(6) WITH TIME ZONE,
    updated_at TIMESTAMP(6) WITH TIME ZONE,
    id UUID NOT NULL,
    PRIMARY KEY (rev, id)
);
ALTER TABLE t_mint_a
    ADD CONSTRAINT fk_mint_a_rev FOREIGN KEY (rev) REFERENCES revinfo;

-- KeySetEntity audit
CREATE TABLE t_keyset_a (
    archived BOOLEAN,
    rev INTEGER NOT NULL,
    revtype SMALLINT,
    unit VARCHAR(5),
    created_at TIMESTAMP(6) WITH TIME ZONE,
    updated_at TIMESTAMP(6) WITH TIME ZONE,
    id UUID NOT NULL,
    key_set_id VARCHAR(16),
    mint_id UUID,
    PRIMARY KEY (rev, id)
);
ALTER TABLE t_keyset_a
    ADD CONSTRAINT fk_keyset_a_rev FOREIGN KEY (rev) REFERENCES revinfo;

-- KeyEntity audit
CREATE TABLE t_key_a (
    amount NUMERIC(38,0),
    archived BOOLEAN,
    rev INTEGER NOT NULL,
    revtype SMALLINT,
    created_at TIMESTAMP(6) WITH TIME ZONE,
    updated_at TIMESTAMP(6) WITH TIME ZONE,
    id UUID NOT NULL,
    key_set_id UUID,
    private_key VARCHAR(255),
    PRIMARY KEY (rev, id)
);
ALTER TABLE t_key_a
    ADD CONSTRAINT fk_key_a_rev FOREIGN KEY (rev) REFERENCES revinfo;

-- ProofEntity audit
CREATE TABLE t_proof_a (
    amount INTEGER,
    archived BOOLEAN,
    rev INTEGER NOT NULL,
    revtype SMALLINT,
    created_at TIMESTAMP(6) WITH TIME ZONE,
    updated_at TIMESTAMP(6) WITH TIME ZONE,
    id UUID NOT NULL,
    mint_id UUID,
    c VARCHAR(255),
    secret VARCHAR(255),
    state VARCHAR(255),
    witness VARCHAR(255),
    PRIMARY KEY (rev, id)
);
ALTER TABLE t_proof_a
    ADD CONSTRAINT fk_proof_a_rev FOREIGN KEY (rev) REFERENCES revinfo;

