-- Seed data for Cashu Vault schema (see db/schema-postgres.sql)
-- Target: PostgreSQL / H2 (PostgreSQL mode)
-- Idempotent across both engines using WHERE NOT EXISTS
-- Order: mint -> keyset -> key -> (optional) proof

-- Mint
INSERT INTO t_mint (id, archived, created_at, updated_at, version)
SELECT '1f240ace-0e4e-42dd-bdcb-9ad4ce8eaeae', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_mint WHERE id = '1f240ace-0e4e-42dd-bdcb-9ad4ce8eaeae');

-- Keyset (references t_mint.id)
INSERT INTO t_keyset (id, key_set_id, unit, mint_id, archived, created_at, updated_at, version)
SELECT 'a086d577-d938-307b-a14d-e729caaeddf2', '00e3372e61d05605', 'sat', '1f240ace-0e4e-42dd-bdcb-9ad4ce8eaeae', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_keyset WHERE id = 'a086d577-d938-307b-a14d-e729caaeddf2');

-- Keys for the keyset (references t_keyset.id)
INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT 'a0f1e55f-5d4b-351f-98f9-77677c3f52ce', 1,    '4fbf609f4d521cf57b93bba3c530d7be1a1e5da7186c2d33990f0a4ead82ccf4', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = 'a0f1e55f-5d4b-351f-98f9-77677c3f52ce');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT '65b31ecd-6830-3329-9132-ae895dbe0928', 2,    '34087457fc5668d84c4adb282b6d6504aee920444a76ad802a496f0470b63bd4', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = '65b31ecd-6830-3329-9132-ae895dbe0928');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT '8d186843-76e7-301e-b704-ae3ff1fae3e3', 4,    '96764f964f8e8f606a104fb107f4bb1566004babb1b1902379a97de8d5f726cc', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = '8d186843-76e7-301e-b704-ae3ff1fae3e3');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT '8535f2eb-f83e-3280-b664-9d52f64f9b37', 8,    '0810f116d6b98fac26fd4529464d234457804e110a398dd69845ca6b68898142', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = '8535f2eb-f83e-3280-b664-9d52f64f9b37');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT 'dd8f0238-d817-3404-a48d-3177545a32db', 16,   '1c5b94ffb5f3f434ef4f7820348b8b2e9f21db8c362daa5b094c8975f9a611b2', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = 'dd8f0238-d817-3404-a48d-3177545a32db');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT 'ed792a7d-6016-31e9-86d9-677abaebb65c', 32,   'c7ed093f604d897091b3b6e34f3005e27e8e8b7e984757153426c1c244e74324', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = 'ed792a7d-6016-31e9-86d9-677abaebb65c');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT '56f3bb2f-a11d-367b-b204-d4dfb00f46ac', 64,   '7f92c62917f281775e2b27d7121cbf135c0583e33e6594d8798325919909bca6', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = '56f3bb2f-a11d-367b-b204-d4dfb00f46ac');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT '35dc585c-1d8b-3d45-932d-cb6574bc6978', 128,  'f242e9ec2a6854a626cdfbeefe3ceddaf31f498376f90284188645b8c44a8dd6', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = '35dc585c-1d8b-3d45-932d-cb6574bc6978');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT 'a3d5a1e2-1c2b-4f0a-9a11-d8f9b7a6c5e4', 256,  '111122223333444455556666777788889999aaaabbbbccccddddeeeeffff0000', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = 'a3d5a1e2-1c2b-4f0a-9a11-d8f9b7a6c5e4');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT 'b4e6c2d3-2d3e-5a1b-8b22-e7f0c9d8e7f0', 512,  '0000fffefdfcfbfaf9f8f7f6f5f4f3f2f1f0efeeedecebeae9e8e7e6e5e4e3e2', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = 'b4e6c2d3-2d3e-5a1b-8b22-e7f0c9d8e7f0');

INSERT INTO t_key (id, amount, private_key, key_set_id, archived, created_at, updated_at, version)
SELECT 'c5f7d3e4-3e4f-6b2c-7c33-f6e1d0cfe6e1', 1024, 'abcdef0123456789fedcba9876543210abcdef0123456789fedcba9876543210', 'a086d577-d938-307b-a14d-e729caaeddf2', false, now(), now(), 0
WHERE NOT EXISTS (SELECT 1 FROM t_key WHERE id = 'c5f7d3e4-3e4f-6b2c-7c33-f6e1d0cfe6e1');

-- Optional: sample Proof (references t_mint.id)
-- Columns: id, amount, archived, version, created_at, updated_at, mint_id, c, secret, state, witness
INSERT INTO t_proof (id, amount, archived, version, created_at, updated_at, mint_id, c, secret, state, witness)
SELECT '0a6d0b92-5505-4f3a-9a8f-1cf2a1d2e3f4', 1, false, 0, now(), now(), '1f240ace-0e4e-42dd-bdcb-9ad4ce8eaeae', 'C_example_signature', 'secret_example', 'UNSPENT', 'seed-witness-1'
WHERE NOT EXISTS (SELECT 1 FROM t_proof WHERE id = '0a6d0b92-5505-4f3a-9a8f-1cf2a1d2e3f4');

-- Verify (optional)
-- SELECT id, archived, created_at, updated_at, version FROM t_mint WHERE id = '1f240ace-0e4e-42dd-bdcb-9ad4ce8eaeae';
-- SELECT id, key_set_id, unit, mint_id FROM t_keyset WHERE id = 'a086d577-d938-307b-a14d-e729caaeddf2';
-- SELECT id, amount FROM t_key WHERE key_set_id = 'a086d577-d938-307b-a14d-e729caaeddf2' ORDER BY amount;
-- SELECT id, amount, state FROM t_proof WHERE mint_id = '1f240ace-0e4e-42dd-bdcb-9ad4ce8eaeae';
