/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.config;

import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="vault.base")
public class VaultBaseProperties {
    private String url = VaultBaseProperties.loadBaseUrl();

    private static String loadBaseUrl() {
        String env = System.getenv("VAULT_BASE_URL");
        if (env != null && !env.isBlank()) {
            return env;
        }
        String property = System.getProperty("vault.base.url");
        if (property != null && !property.isBlank()) {
            return property;
        }
        String port = System.getenv("cashu_vault_port");
        if (port != null && !port.isBlank()) {
            return "http://localhost:" + port;
        }
        return "http://localhost:3333";
    }

    @Generated
    public VaultBaseProperties() {
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultBaseProperties)) {
            return false;
        }
        VaultBaseProperties other = (VaultBaseProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VaultBaseProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "VaultBaseProperties(url=" + this.getUrl() + ")";
    }
}

