/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.controller;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.vault.db.model.KeySetEntity;
import xyz.tcheeric.cashu.vault.db.repos.KeySetRepository;

@RestController
@RequestMapping(value={"/vault/keyset"})
public class KeySetVaultController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeySetVaultController.class);
    private final KeySetRepository keySetRepository;

    @PostMapping
    public ResponseEntity<KeySetEntity> store(@RequestBody KeySetEntity keySet) throws CashuErrorException {
        log.info("Storing KeySetEntity {}", (Object)keySet.getId());
        KeySetEntity newKeySet = (KeySetEntity)this.keySetRepository.save((Object)keySet);
        log.debug("Stored KeySetEntity {}", (Object)newKeySet.getId());
        return ResponseEntity.ok((Object)newKeySet);
    }

    @GetMapping
    public ResponseEntity<List<KeySetEntity>> list() {
        return ResponseEntity.ok((Object)this.keySetRepository.findAll());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<KeySetEntity> retrieve(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Retrieving KeySetEntity {}", (Object)id);
        Optional keySet = this.keySetRepository.findById((Object)UUID.fromString(id));
        if (keySet.isPresent()) {
            log.debug("Retrieved KeySetEntity {}", (Object)((KeySetEntity)keySet.get()).getId());
            return ResponseEntity.ok((Object)((KeySetEntity)keySet.get()));
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/id/{id}"})
    public ResponseEntity<KeySetEntity> retrieveByKeySetId(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Retrieving KeySetEntity by keySetId {}", (Object)id);
        Optional keySet = this.keySetRepository.findByKeySetId(id);
        if (keySet.isPresent()) {
            return ResponseEntity.ok((Object)((KeySetEntity)keySet.get()));
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/unit/{unit}"})
    public ResponseEntity<Set<KeySetEntity>> getKeySetsByUnit(@PathVariable(value="unit") String unit) throws CashuErrorException {
        log.info("Retrieving KeySetEntities for unit {}", (Object)unit);
        Optional keySets = this.keySetRepository.findByUnit(unit);
        Set keySetEntities = keySets.filter(set -> !set.isEmpty()).orElse(new HashSet());
        return ResponseEntity.ok((Object)keySetEntities);
    }

    @GetMapping(value={"/mint/{mintId}/unit/{unit}/keyset/{keySetId}"})
    public ResponseEntity<KeySetEntity> getKeySetByMintIdAndUnit(@PathVariable(value="mintId") String mintId, @PathVariable(value="unit") String unit, @PathVariable(value="keySetId") String keySetId) throws CashuErrorException {
        log.info("Retrieving KeySetEntity for mint {} unit {}", (Object)mintId, (Object)unit);
        Optional keySets = this.keySetRepository.findByMint_IdAndUnit(UUID.fromString(mintId), unit);
        Set keySetEntities = keySets.filter(set -> !set.isEmpty()).orElseThrow(() -> new CashuErrorException("No KeySetEntity found for the specified mintId and unit"));
        return keySetEntities.stream().filter(keySet -> keySet.getKeySetId().equals(keySetId)).findFirst().map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @GetMapping(value={"/mint/{mintId}"})
    public ResponseEntity<Set<KeySetEntity>> getKeySetsByMintId(@PathVariable(value="mintId") String mintId) throws CashuErrorException {
        log.info("Retrieving KeySetEntities for mint {}", (Object)mintId);
        Optional keySets = this.keySetRepository.findByMint_Id(UUID.fromString(mintId));
        Set keySetEntities = keySets.filter(set -> !set.isEmpty()).orElseThrow(() -> new CashuErrorException("No KeySetEntity found for the specified mintId"));
        return ResponseEntity.ok((Object)keySetEntities);
    }

    @PostMapping(value={"/archive/{id}"})
    public ResponseEntity<KeySetEntity> archive(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Archiving KeySetEntity {}", (Object)id);
        Optional keySet = this.keySetRepository.findById((Object)UUID.fromString(id));
        if (keySet.isPresent()) {
            KeySetEntity archivedKeySet = (KeySetEntity)keySet.get();
            archivedKeySet.setArchived(true);
            this.keySetRepository.save((Object)archivedKeySet);
            log.debug("Archived KeySetEntity {}", (Object)archivedKeySet.getId());
            return ResponseEntity.ok((Object)archivedKeySet);
        }
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Deleting KeySetEntity {}", (Object)id);
        Optional keySet = this.keySetRepository.findById((Object)UUID.fromString(id));
        if (keySet.isPresent()) {
            this.keySetRepository.delete((Object)((KeySetEntity)keySet.get()));
            log.debug("Deleted KeySetEntity {}", (Object)((KeySetEntity)keySet.get()).getId());
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.noContent().build();
    }

    @Generated
    public KeySetVaultController(KeySetRepository keySetRepository) {
        this.keySetRepository = keySetRepository;
    }
}

