/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.client;

import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import xyz.tcheeric.cashu.vault.db.client.VaultClient;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;

public class ProofClient
extends VaultClient<ProofEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProofClient.class);

    public ProofClient() {
        super(ProofEntity.class);
    }

    public ProofEntity getByMintIdAndSecret(String mintId, String secret) {
        log.info("GET {}/vault/proof/mint/{}/secret/{}", new Object[]{this.getBaseUrl(), mintId, secret});
        ProofEntity proofEntity = (ProofEntity)this.restTemplate.getForObject(this.getBaseUrl() + "/vault/proof/mint/" + mintId + "/secret/" + secret, ProofEntity.class, new Object[0]);
        return proofEntity;
    }

    public ProofEntity getByMintAndAmount(String mintId, Integer amount) {
        log.info("GET {}/vault/proof/mint/{}/amount/{}", new Object[]{this.getBaseUrl(), mintId, amount});
        ResponseEntity response = this.restTemplate.exchange(this.getBaseUrl() + "/vault/proof/mint/" + mintId + "/amount/" + amount, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Set<ProofEntity>>(this){}, new Object[0]);
        Set optionalProofEntities = (Set)response.getBody();
        if (optionalProofEntities == null || optionalProofEntities.isEmpty()) {
            return null;
        }
        return (ProofEntity)optionalProofEntities.iterator().next();
    }

    public ProofEntity getByMintAndUnblindedSignature(String mintId, String unblindedSignature) {
        log.info("GET {}/vault/proof/mint/{}/signature/{}", new Object[]{this.getBaseUrl(), mintId, unblindedSignature});
        ProofEntity proofEntity = (ProofEntity)this.restTemplate.getForObject(this.getBaseUrl() + "/vault/proof/mint/" + mintId + "/signature/" + unblindedSignature, ProofEntity.class, new Object[0]);
        return proofEntity;
    }

    public ProofEntity getBySecret(String secret) {
        log.info("GET {}/vault/proof/secret/{}", (Object)this.getBaseUrl(), (Object)secret);
        return (ProofEntity)this.restTemplate.getForObject(this.getBaseUrl() + "/vault/proof/secret/" + secret, ProofEntity.class, new Object[0]);
    }
}

