/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;
import xyz.tcheeric.cashu.vault.db.model.BaseEntity;
import xyz.tcheeric.cashu.vault.db.model.KeyEntity;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;

@Entity(name="keyset")
@Table(name="t_keyset", indexes={@Index(name="idx_keyset_unit_mint_unq", columnList="unit, mint_id", unique=true), @Index(name="idx_keyset_key_set_mint_unq", columnList="key_set_id, mint_id", unique=true)})
@Audited
@AuditTable(value="t_keyset_a")
public class KeySetEntity
extends BaseEntity {
    @JsonIgnore
    @OneToMany(mappedBy="keySet", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<KeyEntity> keys = new LinkedHashSet<KeyEntity>();
    @JsonProperty
    @Column(name="key_set_id", nullable=false, length=16)
    private String keySetId;
    @JsonProperty
    @Column(name="unit", nullable=false, length=5)
    private String unit;
    @JsonProperty
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="mint_id")
    private MintEntity mint;

    @Generated
    public KeySetEntity() {
    }

    @Generated
    public Set<KeyEntity> getKeys() {
        return this.keys;
    }

    @Generated
    public String getKeySetId() {
        return this.keySetId;
    }

    @Generated
    public String getUnit() {
        return this.unit;
    }

    @Generated
    public MintEntity getMint() {
        return this.mint;
    }

    @Generated
    public void setKeys(Set<KeyEntity> keys) {
        this.keys = keys;
    }

    @Generated
    public void setKeySetId(String keySetId) {
        this.keySetId = keySetId;
    }

    @Generated
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Generated
    public void setMint(MintEntity mint) {
        this.mint = mint;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeySetEntity)) {
            return false;
        }
        KeySetEntity other = (KeySetEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$keySetId = this.getKeySetId();
        String other$keySetId = other.getKeySetId();
        if (this$keySetId == null ? other$keySetId != null : !this$keySetId.equals(other$keySetId)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        MintEntity this$mint = this.getMint();
        MintEntity other$mint = other.getMint();
        return !(this$mint == null ? other$mint != null : !((Object)this$mint).equals(other$mint));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeySetEntity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $keySetId = this.getKeySetId();
        result = result * 59 + ($keySetId == null ? 43 : $keySetId.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        MintEntity $mint = this.getMint();
        result = result * 59 + ($mint == null ? 43 : ((Object)$mint).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "KeySetEntity(super=" + super.toString() + ", keySetId=" + this.getKeySetId() + ", unit=" + this.getUnit() + ", mint=" + String.valueOf(this.getMint()) + ")";
    }
}

