/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.client;

import jakarta.persistence.Entity;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import xyz.tcheeric.cashu.vault.db.model.BaseEntity;

/*
 * Exception performing whole class analysis ignored.
 */
public class VaultClient<T extends BaseEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VaultClient.class);
    protected final RestTemplate restTemplate = new RestTemplate();
    private String baseUrl;
    private static final String DEFAULT_BASE_URL = "http://localhost:3333";
    private final Class<T> entityType;
    private final String pathSegment;

    public VaultClient(Class<T> entityType) {
        this(entityType, entityType.getAnnotation(Entity.class).name(), VaultClient.loadBaseUrl());
    }

    private VaultClient(Class<T> entityType, String pathSegment, String baseUrl) {
        this.entityType = entityType;
        this.pathSegment = pathSegment;
        this.baseUrl = baseUrl;
    }

    public VaultClient(Class<T> entityType, String baseUrl) {
        this(entityType, entityType.getAnnotation(Entity.class).name(), baseUrl);
    }

    private static String loadBaseUrl() {
        String env = System.getenv("VAULT_BASE_URL");
        if (env != null && !env.isBlank()) {
            return VaultClient.removeTrailingSlash((String)env);
        }
        String property = System.getProperty("vault.base.url");
        if (property != null && !property.isBlank()) {
            return VaultClient.removeTrailingSlash((String)property);
        }
        String port = System.getenv("cashu_vault_port");
        if (port != null && !port.isBlank()) {
            return "http://localhost:" + port;
        }
        return "http://localhost:3333";
    }

    private static String removeTrailingSlash(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public T store(T entity) {
        log.info("POST {}/vault/{}/", (Object)this.baseUrl, (Object)this.pathSegment);
        BaseEntity response = (BaseEntity)this.restTemplate.postForObject(this.baseUrl + "/vault/" + this.pathSegment, entity, this.entityType, new Object[0]);
        log.debug("Stored entity: {}", response != null ? response.getId() : "null");
        return (T)response;
    }

    public T retrieve(String id) {
        log.info("GET {}/vault/{}/{}", new Object[]{this.baseUrl, this.pathSegment, id});
        return (T)((BaseEntity)this.restTemplate.getForObject(this.baseUrl + "/vault/" + this.pathSegment + "/" + id, this.entityType, new Object[0]));
    }

    public T archive(String id) {
        log.info("POST {}/vault/{}/archive/{}", new Object[]{this.baseUrl, this.pathSegment, id});
        return (T)((BaseEntity)this.restTemplate.postForObject(this.baseUrl + "/vault/" + this.pathSegment + "/archive/" + id, null, this.entityType, new Object[0]));
    }

    public void delete(String id) {
        log.info("DELETE {}/vault/{}/{}", new Object[]{this.baseUrl, this.pathSegment, id});
        this.restTemplate.delete(this.baseUrl + "/vault/" + this.pathSegment + "/" + id, new Object[0]);
    }

    public List<T> retrieveAll() {
        log.info("GET {}/vault/{}/", (Object)this.baseUrl, (Object)this.pathSegment);
        ResponseEntity response = this.restTemplate.exchange(this.baseUrl + "/vault/" + this.pathSegment, HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        List body = (List)response.getBody();
        return body != null ? body : Collections.emptyList();
    }

    @Generated
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public Class<T> getEntityType() {
        return this.entityType;
    }

    @Generated
    public String getPathSegment() {
        return this.pathSegment;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultClient)) {
            return false;
        }
        VaultClient other = (VaultClient)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        if (this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        Class this$entityType = this.getEntityType();
        Class other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$pathSegment = this.getPathSegment();
        String other$pathSegment = other.getPathSegment();
        return !(this$pathSegment == null ? other$pathSegment != null : !this$pathSegment.equals(other$pathSegment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VaultClient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        Class $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $pathSegment = this.getPathSegment();
        result = result * 59 + ($pathSegment == null ? 43 : $pathSegment.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "VaultClient(restTemplate=" + String.valueOf(this.getRestTemplate()) + ", baseUrl=" + this.getBaseUrl() + ", entityType=" + String.valueOf(this.getEntityType()) + ", pathSegment=" + this.getPathSegment() + ")";
    }
}

