/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.vault.db.controller;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;
import xyz.tcheeric.cashu.vault.db.repos.ProofRepository;

@RestController
@RequestMapping(value={"/vault/proof"})
public class ProofVaultController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProofVaultController.class);
    private final ProofRepository proofRepository;

    @PostMapping
    public ResponseEntity<ProofEntity> store(@RequestBody ProofEntity proof) throws CashuErrorException {
        log.info("Storing ProofEntity {}", (Object)proof.getId());
        ProofEntity savedProof = (ProofEntity)this.proofRepository.save((Object)proof);
        log.debug("Stored ProofEntity {}", (Object)savedProof.getId());
        return ResponseEntity.ok((Object)savedProof);
    }

    @GetMapping
    public ResponseEntity<List<ProofEntity>> list() {
        return ResponseEntity.ok((Object)this.proofRepository.findAll());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ProofEntity> retrieve(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Retrieving ProofEntity by id {}", (Object)id);
        Optional proofOpt = this.proofRepository.findById((Object)UUID.fromString(id));
        if (proofOpt.isPresent()) {
            log.debug("Retrieved ProofEntity by id {}", (Object)((ProofEntity)proofOpt.get()).getId());
            return ResponseEntity.ok((Object)((ProofEntity)proofOpt.get()));
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/mint/{mintId}"})
    public ResponseEntity<Set<ProofEntity>> retrieveByMint(@PathVariable(value="mintId") String mintId) throws CashuErrorException {
        log.info("Retrieving ProofEntities by mintId {}", (Object)mintId);
        Optional proofs = this.proofRepository.findByMint_Id(UUID.fromString(mintId));
        if (proofs.isPresent() && !((Set)proofs.get()).isEmpty()) {
            return ResponseEntity.ok((Object)((Set)proofs.get()));
        }
        throw new CashuErrorException("No ProofEntities found for the given Mint ID");
    }

    @GetMapping(value={"/secret/{secret}"})
    public ResponseEntity<ProofEntity> retrieveBySecret(@PathVariable(value="secret") String secret) throws CashuErrorException {
        log.debug("Retrieving ProofEntity by secret {}", (Object)secret);
        Optional proof = this.proofRepository.findBySecret(secret);
        if (proof.isPresent()) {
            log.debug("Retrieved ProofEntity by secret {}", (Object)secret);
            return ResponseEntity.ok((Object)((ProofEntity)proof.get()));
        }
        log.warn("No ProofEntity found for the specified secret");
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/mint/{mintId}/secret/{secret}"})
    public ResponseEntity<ProofEntity> retrieveByMintAndSecret(@PathVariable(value="mintId") String mintId, @PathVariable(value="secret") String secret) throws CashuErrorException {
        log.info("Retrieving ProofEntity by mintId {} and secret {}", (Object)mintId, (Object)secret);
        Optional proof = this.proofRepository.findByMint_IdAndSecret(UUID.fromString(mintId), secret);
        if (proof.isPresent()) {
            log.debug("Retrieved ProofEntity by mintId {} and secret {}", (Object)mintId, (Object)secret);
            return ResponseEntity.ok((Object)((ProofEntity)proof.get()));
        }
        log.warn("No ProofEntity found for the specified mint and secret");
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/mint/{mintId}/amount/{amount}"})
    public ResponseEntity<Set<ProofEntity>> retrieveByMintAndAmount(@PathVariable(value="mintId") String mintId, @PathVariable(value="amount") Integer amount) throws CashuErrorException {
        log.info("Retrieving ProofEntities by mintId {} and amount {}", (Object)mintId, (Object)amount);
        Optional proofs = this.proofRepository.findByMint_IdAndAmount(UUID.fromString(mintId), amount);
        if (proofs.isPresent() && !((Set)proofs.get()).isEmpty()) {
            return ResponseEntity.ok((Object)((Set)proofs.get()));
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/mint/{mintId}/signature/{unblindedSignature}"})
    public ResponseEntity<ProofEntity> retrieveByMintAndUnblindedSignature(@PathVariable(value="mintId") String mintId, @PathVariable(value="unblindedSignature") String unblindedSignature) throws CashuErrorException {
        log.info("Retrieving ProofEntity by mintId {} and signature {}", (Object)mintId, (Object)unblindedSignature);
        Optional proof = this.proofRepository.findByMint_IdAndUnblindedSignature(UUID.fromString(mintId), unblindedSignature);
        if (proof.isPresent()) {
            log.debug("Retrieved ProofEntity by mintId {} and signature {}", (Object)mintId, (Object)unblindedSignature);
            return ResponseEntity.ok((Object)((ProofEntity)proof.get()));
        }
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/archive/{id}"})
    public ResponseEntity<ProofEntity> archive(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Archiving ProofEntity {}", (Object)id);
        Optional proofOpt = this.proofRepository.findById((Object)UUID.fromString(id));
        if (proofOpt.isPresent()) {
            ProofEntity proof = (ProofEntity)proofOpt.get();
            proof.setArchived(true);
            ProofEntity archivedProof = (ProofEntity)this.proofRepository.save((Object)proof);
            log.debug("Archived ProofEntity {}", (Object)archivedProof.getId());
            return ResponseEntity.ok((Object)archivedProof);
        }
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") String id) throws CashuErrorException {
        log.info("Deleting ProofEntity {}", (Object)id);
        Optional proofOpt = this.proofRepository.findById((Object)UUID.fromString(id));
        if (proofOpt.isPresent()) {
            this.proofRepository.delete((Object)((ProofEntity)proofOpt.get()));
            log.debug("Deleted ProofEntity {}", (Object)((ProofEntity)proofOpt.get()).getId());
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.noContent().build();
    }

    @Generated
    public ProofVaultController(ProofRepository proofRepository) {
        this.proofRepository = proofRepository;
    }
}

