/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.app.dto;

import java.util.Map;
import xyz.tcheeric.cashu.voucher.domain.BackingStrategy;

public class IssueVoucherRequest {
    private String issuerId;
    private String unit;
    private Long amount;
    private Integer expiresInDays;
    private String memo;
    private String voucherId;
    private BackingStrategy backingStrategy;
    private double issuanceRatio;
    private int faceDecimals;
    private Map<String, Object> merchantMetadata;

    private static BackingStrategy $default$backingStrategy() {
        return BackingStrategy.FIXED;
    }

    private static double $default$issuanceRatio() {
        return 1.0;
    }

    private static int $default$faceDecimals() {
        return 0;
    }

    public static IssueVoucherRequestBuilder builder() {
        return new IssueVoucherRequestBuilder();
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public String getUnit() {
        return this.unit;
    }

    public Long getAmount() {
        return this.amount;
    }

    public Integer getExpiresInDays() {
        return this.expiresInDays;
    }

    public String getMemo() {
        return this.memo;
    }

    public String getVoucherId() {
        return this.voucherId;
    }

    public BackingStrategy getBackingStrategy() {
        return this.backingStrategy;
    }

    public double getIssuanceRatio() {
        return this.issuanceRatio;
    }

    public int getFaceDecimals() {
        return this.faceDecimals;
    }

    public Map<String, Object> getMerchantMetadata() {
        return this.merchantMetadata;
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public void setExpiresInDays(Integer expiresInDays) {
        this.expiresInDays = expiresInDays;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public void setVoucherId(String voucherId) {
        this.voucherId = voucherId;
    }

    public void setBackingStrategy(BackingStrategy backingStrategy) {
        this.backingStrategy = backingStrategy;
    }

    public void setIssuanceRatio(double issuanceRatio) {
        this.issuanceRatio = issuanceRatio;
    }

    public void setFaceDecimals(int faceDecimals) {
        this.faceDecimals = faceDecimals;
    }

    public void setMerchantMetadata(Map<String, Object> merchantMetadata) {
        this.merchantMetadata = merchantMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueVoucherRequest)) {
            return false;
        }
        IssueVoucherRequest other = (IssueVoucherRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getIssuanceRatio(), other.getIssuanceRatio()) != 0) {
            return false;
        }
        if (this.getFaceDecimals() != other.getFaceDecimals()) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Integer this$expiresInDays = this.getExpiresInDays();
        Integer other$expiresInDays = other.getExpiresInDays();
        if (this$expiresInDays == null ? other$expiresInDays != null : !((Object)this$expiresInDays).equals(other$expiresInDays)) {
            return false;
        }
        String this$issuerId = this.getIssuerId();
        String other$issuerId = other.getIssuerId();
        if (this$issuerId == null ? other$issuerId != null : !this$issuerId.equals(other$issuerId)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$memo = this.getMemo();
        String other$memo = other.getMemo();
        if (this$memo == null ? other$memo != null : !this$memo.equals(other$memo)) {
            return false;
        }
        String this$voucherId = this.getVoucherId();
        String other$voucherId = other.getVoucherId();
        if (this$voucherId == null ? other$voucherId != null : !this$voucherId.equals(other$voucherId)) {
            return false;
        }
        BackingStrategy this$backingStrategy = this.getBackingStrategy();
        BackingStrategy other$backingStrategy = other.getBackingStrategy();
        if (this$backingStrategy == null ? other$backingStrategy != null : !this$backingStrategy.equals(other$backingStrategy)) {
            return false;
        }
        Map<String, Object> this$merchantMetadata = this.getMerchantMetadata();
        Map<String, Object> other$merchantMetadata = other.getMerchantMetadata();
        return !(this$merchantMetadata == null ? other$merchantMetadata != null : !((Object)this$merchantMetadata).equals(other$merchantMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueVoucherRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $issuanceRatio = Double.doubleToLongBits(this.getIssuanceRatio());
        result = result * 59 + (int)($issuanceRatio >>> 32 ^ $issuanceRatio);
        result = result * 59 + this.getFaceDecimals();
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Integer $expiresInDays = this.getExpiresInDays();
        result = result * 59 + ($expiresInDays == null ? 43 : ((Object)$expiresInDays).hashCode());
        String $issuerId = this.getIssuerId();
        result = result * 59 + ($issuerId == null ? 43 : $issuerId.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
        String $voucherId = this.getVoucherId();
        result = result * 59 + ($voucherId == null ? 43 : $voucherId.hashCode());
        BackingStrategy $backingStrategy = this.getBackingStrategy();
        result = result * 59 + ($backingStrategy == null ? 43 : $backingStrategy.hashCode());
        Map<String, Object> $merchantMetadata = this.getMerchantMetadata();
        result = result * 59 + ($merchantMetadata == null ? 43 : ((Object)$merchantMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "IssueVoucherRequest(issuerId=" + this.getIssuerId() + ", unit=" + this.getUnit() + ", amount=" + this.getAmount() + ", expiresInDays=" + this.getExpiresInDays() + ", memo=" + this.getMemo() + ", voucherId=" + this.getVoucherId() + ", backingStrategy=" + String.valueOf(this.getBackingStrategy()) + ", issuanceRatio=" + this.getIssuanceRatio() + ", faceDecimals=" + this.getFaceDecimals() + ", merchantMetadata=" + String.valueOf(this.getMerchantMetadata()) + ")";
    }

    public IssueVoucherRequest() {
        this.backingStrategy = IssueVoucherRequest.$default$backingStrategy();
        this.issuanceRatio = IssueVoucherRequest.$default$issuanceRatio();
        this.faceDecimals = IssueVoucherRequest.$default$faceDecimals();
    }

    public IssueVoucherRequest(String issuerId, String unit, Long amount, Integer expiresInDays, String memo, String voucherId, BackingStrategy backingStrategy, double issuanceRatio, int faceDecimals, Map<String, Object> merchantMetadata) {
        this.issuerId = issuerId;
        this.unit = unit;
        this.amount = amount;
        this.expiresInDays = expiresInDays;
        this.memo = memo;
        this.voucherId = voucherId;
        this.backingStrategy = backingStrategy;
        this.issuanceRatio = issuanceRatio;
        this.faceDecimals = faceDecimals;
        this.merchantMetadata = merchantMetadata;
    }

    public static class IssueVoucherRequestBuilder {
        private String issuerId;
        private String unit;
        private Long amount;
        private Integer expiresInDays;
        private String memo;
        private String voucherId;
        private boolean backingStrategy$set;
        private BackingStrategy backingStrategy$value;
        private boolean issuanceRatio$set;
        private double issuanceRatio$value;
        private boolean faceDecimals$set;
        private int faceDecimals$value;
        private Map<String, Object> merchantMetadata;

        IssueVoucherRequestBuilder() {
        }

        public IssueVoucherRequestBuilder issuerId(String issuerId) {
            this.issuerId = issuerId;
            return this;
        }

        public IssueVoucherRequestBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public IssueVoucherRequestBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public IssueVoucherRequestBuilder expiresInDays(Integer expiresInDays) {
            this.expiresInDays = expiresInDays;
            return this;
        }

        public IssueVoucherRequestBuilder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public IssueVoucherRequestBuilder voucherId(String voucherId) {
            this.voucherId = voucherId;
            return this;
        }

        public IssueVoucherRequestBuilder backingStrategy(BackingStrategy backingStrategy) {
            this.backingStrategy$value = backingStrategy;
            this.backingStrategy$set = true;
            return this;
        }

        public IssueVoucherRequestBuilder issuanceRatio(double issuanceRatio) {
            this.issuanceRatio$value = issuanceRatio;
            this.issuanceRatio$set = true;
            return this;
        }

        public IssueVoucherRequestBuilder faceDecimals(int faceDecimals) {
            this.faceDecimals$value = faceDecimals;
            this.faceDecimals$set = true;
            return this;
        }

        public IssueVoucherRequestBuilder merchantMetadata(Map<String, Object> merchantMetadata) {
            this.merchantMetadata = merchantMetadata;
            return this;
        }

        public IssueVoucherRequest build() {
            BackingStrategy backingStrategy$value = this.backingStrategy$value;
            if (!this.backingStrategy$set) {
                backingStrategy$value = IssueVoucherRequest.$default$backingStrategy();
            }
            double issuanceRatio$value = this.issuanceRatio$value;
            if (!this.issuanceRatio$set) {
                issuanceRatio$value = IssueVoucherRequest.$default$issuanceRatio();
            }
            int faceDecimals$value = this.faceDecimals$value;
            if (!this.faceDecimals$set) {
                faceDecimals$value = IssueVoucherRequest.$default$faceDecimals();
            }
            return new IssueVoucherRequest(this.issuerId, this.unit, this.amount, this.expiresInDays, this.memo, this.voucherId, backingStrategy$value, issuanceRatio$value, faceDecimals$value, this.merchantMetadata);
        }

        public String toString() {
            return "IssueVoucherRequest.IssueVoucherRequestBuilder(issuerId=" + this.issuerId + ", unit=" + this.unit + ", amount=" + this.amount + ", expiresInDays=" + this.expiresInDays + ", memo=" + this.memo + ", voucherId=" + this.voucherId + ", backingStrategy$value=" + String.valueOf(this.backingStrategy$value) + ", issuanceRatio$value=" + this.issuanceRatio$value + ", faceDecimals$value=" + this.faceDecimals$value + ", merchantMetadata=" + String.valueOf(this.merchantMetadata) + ")";
        }
    }
}

