/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.domain.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;

public final class VoucherSerializationUtils {
    private static final ObjectMapper CBOR_MAPPER = new ObjectMapper((JsonFactory)new CBORFactory());

    private VoucherSerializationUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static byte[] toCbor(@NonNull Map<String, Object> data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        try {
            return CBOR_MAPPER.writeValueAsBytes(data);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialize voucher data to CBOR", e);
        }
    }

    public static Map<String, Object> fromCbor(@NonNull byte[] cborBytes) {
        if (cborBytes == null) {
            throw new NullPointerException("cborBytes is marked non-null but is null");
        }
        try {
            return (Map)CBOR_MAPPER.readValue(cborBytes, Map.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to deserialize CBOR data", e);
        }
    }
}

