/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.domain;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.BaseKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.voucher.domain.BackingStrategy;
import xyz.tcheeric.cashu.voucher.domain.VoucherSecretSerializer;
import xyz.tcheeric.cashu.voucher.domain.util.VoucherSerializationUtils;

@JsonSerialize(using=VoucherSecretSerializer.class)
public final class VoucherSecret
extends BaseKey
implements Secret {
    private final String voucherId;
    private final String issuerId;
    private final String unit;
    private final long faceValue;
    private final Long expiresAt;
    private final String memo;
    private final BackingStrategy backingStrategy;
    private final double issuanceRatio;
    private final int faceDecimals;
    private final Map<String, Object> merchantMetadata;

    private VoucherSecret(@NonNull String voucherId, @NonNull String issuerId, @NonNull String unit, long faceValue, Long expiresAt, String memo, @NonNull BackingStrategy backingStrategy, double issuanceRatio, int faceDecimals, Map<String, Object> merchantMetadata) {
        super(new byte[0]);
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        if (issuerId == null) {
            throw new NullPointerException("issuerId is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (backingStrategy == null) {
            throw new NullPointerException("backingStrategy is marked non-null but is null");
        }
        if (faceValue <= 0L) {
            throw new IllegalArgumentException("Face value must be positive, got: " + faceValue);
        }
        if (voucherId.isBlank()) {
            throw new IllegalArgumentException("Voucher ID cannot be blank");
        }
        if (issuerId.isBlank()) {
            throw new IllegalArgumentException("Issuer ID cannot be blank");
        }
        if (unit.isBlank()) {
            throw new IllegalArgumentException("Unit cannot be blank");
        }
        if (expiresAt != null && expiresAt <= 0L) {
            throw new IllegalArgumentException("Expiry timestamp must be positive if provided");
        }
        if (issuanceRatio <= 0.0) {
            throw new IllegalArgumentException("Issuance ratio must be positive, got: " + issuanceRatio);
        }
        if (faceDecimals < 0) {
            throw new IllegalArgumentException("Face decimals must be non-negative, got: " + faceDecimals);
        }
        this.voucherId = voucherId;
        this.issuerId = issuerId;
        this.unit = unit;
        this.faceValue = faceValue;
        this.expiresAt = expiresAt;
        this.memo = memo;
        this.backingStrategy = backingStrategy;
        this.issuanceRatio = issuanceRatio;
        this.faceDecimals = faceDecimals;
        this.merchantMetadata = merchantMetadata != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Object>(merchantMetadata)) : Collections.emptyMap();
        this.setBytes(this.toCanonicalBytes());
    }

    public static VoucherSecret create(@NonNull String issuerId, @NonNull String unit, long faceValue, Long expiresAt, String memo, @NonNull BackingStrategy backingStrategy, double issuanceRatio, int faceDecimals, Map<String, Object> merchantMetadata) {
        if (issuerId == null) {
            throw new NullPointerException("issuerId is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (backingStrategy == null) {
            throw new NullPointerException("backingStrategy is marked non-null but is null");
        }
        return new VoucherSecret(UUID.randomUUID().toString(), issuerId, unit, faceValue, expiresAt, memo, backingStrategy, issuanceRatio, faceDecimals, merchantMetadata);
    }

    public static VoucherSecret create(@NonNull String voucherId, @NonNull String issuerId, @NonNull String unit, long faceValue, Long expiresAt, String memo, @NonNull BackingStrategy backingStrategy, double issuanceRatio, int faceDecimals, Map<String, Object> merchantMetadata) {
        if (voucherId == null) {
            throw new NullPointerException("voucherId is marked non-null but is null");
        }
        if (issuerId == null) {
            throw new NullPointerException("issuerId is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (backingStrategy == null) {
            throw new NullPointerException("backingStrategy is marked non-null but is null");
        }
        return new VoucherSecret(voucherId, issuerId, unit, faceValue, expiresAt, memo, backingStrategy, issuanceRatio, faceDecimals, merchantMetadata);
    }

    public static Builder builder() {
        return new Builder();
    }

    public byte[] toCanonicalBytes() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("backingStrategy", this.backingStrategy.name());
        if (this.expiresAt != null) {
            map.put("expiresAt", this.expiresAt);
        }
        map.put("faceDecimals", this.faceDecimals);
        map.put("faceValue", this.faceValue);
        map.put("issuanceRatio", this.issuanceRatio);
        map.put("issuerId", this.issuerId);
        if (this.memo != null && !this.memo.isBlank()) {
            map.put("memo", this.memo);
        }
        if (this.merchantMetadata != null && !this.merchantMetadata.isEmpty()) {
            map.put("merchantMetadata", this.merchantMetadata);
        }
        map.put("unit", this.unit);
        map.put("voucherId", this.voucherId);
        return VoucherSerializationUtils.toCbor(map);
    }

    public String toHexString() {
        return Hex.toHexString((byte[])this.toCanonicalBytes());
    }

    public byte[] toBytes() {
        return this.toCanonicalBytes();
    }

    public byte[] getData() {
        return this.toCanonicalBytes();
    }

    public void setData(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        throw new UnsupportedOperationException("VoucherSecret is immutable");
    }

    public boolean isExpired() {
        return this.expiresAt != null && Instant.now().getEpochSecond() > this.expiresAt;
    }

    public boolean isValid() {
        return !this.isExpired();
    }

    public String toString() {
        return this.toHexString();
    }

    public String toStringWithMetadata() {
        StringBuilder sb = new StringBuilder();
        sb.append("VoucherSecret{");
        sb.append("voucherId='").append(this.voucherId).append('\'');
        sb.append(", issuerId='").append(this.issuerId).append('\'');
        sb.append(", unit='").append(this.unit).append('\'');
        sb.append(", faceValue=").append(this.faceValue);
        sb.append(", faceDecimals=").append(this.faceDecimals);
        sb.append(", backingStrategy=").append((Object)this.backingStrategy);
        sb.append(", issuanceRatio=").append(this.issuanceRatio);
        if (this.expiresAt != null) {
            sb.append(", expiresAt=").append(this.expiresAt);
            sb.append(" (").append(this.isExpired() ? "EXPIRED" : "valid").append(")");
        }
        if (this.memo != null) {
            sb.append(", memo='").append(this.memo).append('\'');
        }
        if (!this.merchantMetadata.isEmpty()) {
            sb.append(", merchantMetadata=").append(this.merchantMetadata);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VoucherSecret that = (VoucherSecret)((Object)o);
        return this.faceValue == that.faceValue && this.faceDecimals == that.faceDecimals && Double.compare(this.issuanceRatio, that.issuanceRatio) == 0 && this.voucherId.equals(that.voucherId) && this.issuerId.equals(that.issuerId) && this.unit.equals(that.unit) && this.backingStrategy == that.backingStrategy && Objects.equals(this.expiresAt, that.expiresAt) && Objects.equals(this.memo, that.memo) && Objects.equals(this.merchantMetadata, that.merchantMetadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.voucherId, this.issuerId, this.unit, this.faceValue, this.expiresAt, this.memo, this.backingStrategy, this.issuanceRatio, this.faceDecimals, this.merchantMetadata});
    }

    public String getVoucherId() {
        return this.voucherId;
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public String getUnit() {
        return this.unit;
    }

    public long getFaceValue() {
        return this.faceValue;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getMemo() {
        return this.memo;
    }

    public BackingStrategy getBackingStrategy() {
        return this.backingStrategy;
    }

    public double getIssuanceRatio() {
        return this.issuanceRatio;
    }

    public int getFaceDecimals() {
        return this.faceDecimals;
    }

    public Map<String, Object> getMerchantMetadata() {
        return this.merchantMetadata;
    }

    public static class Builder {
        private String voucherId;
        private String issuerId;
        private String unit;
        private long faceValue;
        private Long expiresAt;
        private String memo;
        private BackingStrategy backingStrategy;
        private double issuanceRatio;
        private int faceDecimals;
        private Map<String, Object> merchantMetadata;

        public Builder voucherId(String voucherId) {
            this.voucherId = voucherId;
            return this;
        }

        public Builder issuerId(String issuerId) {
            this.issuerId = issuerId;
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public Builder faceValue(long faceValue) {
            this.faceValue = faceValue;
            return this;
        }

        public Builder expiresAt(Long expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder backingStrategy(BackingStrategy backingStrategy) {
            this.backingStrategy = backingStrategy;
            return this;
        }

        public Builder issuanceRatio(double issuanceRatio) {
            this.issuanceRatio = issuanceRatio;
            return this;
        }

        public Builder faceDecimals(int faceDecimals) {
            this.faceDecimals = faceDecimals;
            return this;
        }

        public Builder merchantMetadata(Map<String, Object> merchantMetadata) {
            this.merchantMetadata = merchantMetadata;
            return this;
        }

        public VoucherSecret build() {
            String id = this.voucherId != null ? this.voucherId : UUID.randomUUID().toString();
            return new VoucherSecret(id, this.issuerId, this.unit, this.faceValue, this.expiresAt, this.memo, this.backingStrategy, this.issuanceRatio, this.faceDecimals, this.merchantMetadata);
        }
    }
}

