/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.domain;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import lombok.NonNull;
import nostr.crypto.schnorr.Schnorr;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.domain.VoucherSecret;

public final class VoucherSignatureService {
    private static final Logger logger = LoggerFactory.getLogger(VoucherSignatureService.class);
    private static final int SECP256K1_PRIVATE_KEY_LENGTH = 32;
    private static final int SECP256K1_PUBLIC_KEY_LENGTH = 32;
    private static final int SCHNORR_SIGNATURE_LENGTH = 64;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private VoucherSignatureService() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static byte[] sign(@NonNull VoucherSecret secret, @NonNull String issuerPrivateKeyHex) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (issuerPrivateKeyHex == null) {
            throw new NullPointerException("issuerPrivateKeyHex is marked non-null but is null");
        }
        try {
            byte[] privateKeyBytes = Hex.decode((String)issuerPrivateKeyHex);
            if (privateKeyBytes.length != 32) {
                throw new IllegalArgumentException("Invalid private key length: expected 32 bytes, got " + privateKeyBytes.length);
            }
            byte[] canonicalBytes = secret.toCanonicalBytes();
            byte[] messageHash = VoucherSignatureService.sha256(canonicalBytes);
            byte[] auxRand = new byte[32];
            SECURE_RANDOM.nextBytes(auxRand);
            byte[] signature = Schnorr.sign((byte[])messageHash, (byte[])privateKeyBytes, (byte[])auxRand);
            if (logger.isDebugEnabled()) {
                logger.debug("Signed voucher {} (issuerId={}) with Schnorr signature length={}", new Object[]{secret.getVoucherId(), secret.getIssuerId(), signature.length});
            }
            return signature;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to sign voucher: " + e.getMessage(), e);
        }
    }

    public static boolean verify(@NonNull VoucherSecret secret, @NonNull byte[] signature, @NonNull String issuerPublicKeyHex) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        if (issuerPublicKeyHex == null) {
            throw new NullPointerException("issuerPublicKeyHex is marked non-null but is null");
        }
        try {
            if (signature.length != 64) {
                logger.warn("Invalid signature length for voucher {}: expected {} bytes, got {}", new Object[]{secret.getVoucherId(), 64, signature.length});
                return false;
            }
            byte[] publicKeyBytes = Hex.decode((String)issuerPublicKeyHex);
            if (publicKeyBytes.length != 32) {
                logger.warn("Invalid public key length: expected {} bytes, got {}", (Object)32, (Object)publicKeyBytes.length);
                return false;
            }
            byte[] canonicalBytes = secret.toCanonicalBytes();
            byte[] messageHash = VoucherSignatureService.sha256(canonicalBytes);
            boolean valid = Schnorr.verify((byte[])messageHash, (byte[])publicKeyBytes, (byte[])signature);
            if (logger.isDebugEnabled()) {
                logger.debug("Verified voucher {} (issuerId={}): {}", new Object[]{secret.getVoucherId(), secret.getIssuerId(), valid ? "VALID" : "INVALID"});
            }
            return valid;
        }
        catch (Exception e) {
            logger.warn("Signature verification failed for voucher {}: {}", (Object)secret.getVoucherId(), (Object)e.getMessage());
            return false;
        }
    }

    public static SignedVoucher createSigned(@NonNull VoucherSecret secret, @NonNull String issuerPrivateKeyHex, @NonNull String issuerPublicKeyHex) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (issuerPrivateKeyHex == null) {
            throw new NullPointerException("issuerPrivateKeyHex is marked non-null but is null");
        }
        if (issuerPublicKeyHex == null) {
            throw new NullPointerException("issuerPublicKeyHex is marked non-null but is null");
        }
        byte[] signature = VoucherSignatureService.sign(secret, issuerPrivateKeyHex);
        return new SignedVoucher(secret, signature, issuerPublicKeyHex);
    }

    private static byte[] sha256(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 not available", e);
        }
    }
}

