/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.nostr.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.crypto.Point;
import nostr.crypto.nip44.EncryptedPayloads;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.util.NostrUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.nostr.VoucherNostrException;
import xyz.tcheeric.cashu.voucher.nostr.events.VoucherEventPayloadMapper;

public class VoucherBackupPayload {
    private static final Logger log = LoggerFactory.getLogger(VoucherBackupPayload.class);
    public static final String PAYLOAD_VERSION = "1.0";
    public static final int KIND_ENCRYPTED_DM = Kind.ENCRYPTED_DIRECT_MESSAGE.getValue();
    public static final String TAG_BACKUP = "backup";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static GenericEvent createBackupEvent(@NonNull List<SignedVoucher> vouchers, @NonNull String userPrivkey, @NonNull String userPubkey) {
        String encryptedContent;
        String payloadJson;
        if (vouchers == null) {
            throw new NullPointerException("vouchers is marked non-null but is null");
        }
        if (userPrivkey == null) {
            throw new NullPointerException("userPrivkey is marked non-null but is null");
        }
        if (userPubkey == null) {
            throw new NullPointerException("userPubkey is marked non-null but is null");
        }
        if (userPrivkey.isBlank()) {
            throw new IllegalArgumentException("User private key cannot be blank");
        }
        if (userPubkey.isBlank()) {
            throw new IllegalArgumentException("User public key cannot be blank");
        }
        log.info("Creating backup event for {} voucher(s)", (Object)vouchers.size());
        BackupPayload payload = new BackupPayload();
        payload.setVersion(PAYLOAD_VERSION);
        long backupTimestamp = System.currentTimeMillis() / 1000L;
        ArrayList<VoucherBackupEntry> entries = new ArrayList<VoucherBackupEntry>();
        for (SignedVoucher voucher : vouchers) {
            VoucherBackupEntry entry = new VoucherBackupEntry();
            entry.setVoucher(VoucherEventPayloadMapper.toPayload(voucher));
            entry.setBackedUpAt(backupTimestamp);
            entries.add(entry);
        }
        payload.setVouchers(entries);
        BackupMetadata metadata = new BackupMetadata();
        metadata.setTotalCount(vouchers.size());
        metadata.setBackupTimestamp(backupTimestamp);
        payload.setMetadata(metadata);
        try {
            payloadJson = objectMapper.writeValueAsString((Object)payload);
            log.debug("Serialized backup payload: {} bytes", (Object)payloadJson.length());
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize backup payload", (Throwable)e);
            throw new VoucherNostrException("Failed to serialize backup payload", e);
        }
        try {
            PublicKey recipientPubKey = new PublicKey(userPubkey);
            byte[] xOnlyBytes = recipientPubKey.getRawData();
            String uncompressedHex = VoucherBackupPayload.convertXOnlyToUncompressed(xOnlyBytes);
            byte[] conversationKey = EncryptedPayloads.getConversationKey((String)userPrivkey, (String)uncompressedHex);
            byte[] nonce = new byte[32];
            SECURE_RANDOM.nextBytes(nonce);
            encryptedContent = EncryptedPayloads.encrypt((String)payloadJson, (byte[])conversationKey, (byte[])nonce);
            log.debug("Encrypted payload with NIP-44: {} bytes", (Object)encryptedContent.length());
        }
        catch (Exception e) {
            log.error("Failed to encrypt backup payload", (Throwable)e);
            throw new VoucherNostrException("Failed to encrypt backup payload", e);
        }
        GenericEvent event = new GenericEvent();
        event.setKind(Integer.valueOf(KIND_ENCRYPTED_DM));
        event.setPubKey(new PublicKey(userPubkey));
        event.setCreatedAt(Long.valueOf(backupTimestamp));
        event.setContent(encryptedContent);
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
        tags.add(BaseTag.create((String)"p", (String[])new String[]{userPubkey}));
        tags.add(BaseTag.create((String)TAG_BACKUP, (String[])new String[]{"vouchers"}));
        event.setTags(tags);
        log.info("Created backup event: {} vouchers encrypted", (Object)vouchers.size());
        return event;
    }

    private static String convertXOnlyToUncompressed(byte[] xOnlyBytes) {
        if (xOnlyBytes.length != 32) {
            throw new IllegalArgumentException("Expected 32-byte x-only public key, got " + xOnlyBytes.length);
        }
        Point point = Point.liftX((byte[])xOnlyBytes);
        byte[] uncompressed = new byte[65];
        uncompressed[0] = 4;
        byte[] xBytes = point.getX().toByteArray();
        byte[] yBytes = point.getY().toByteArray();
        int xStart = xBytes.length > 32 ? xBytes.length - 32 : 0;
        int xDest = xBytes.length >= 32 ? 1 : 1 + (32 - xBytes.length);
        System.arraycopy(xBytes, xStart, uncompressed, xDest, Math.min(xBytes.length, 32));
        int yStart = yBytes.length > 32 ? yBytes.length - 32 : 0;
        int yDest = yBytes.length >= 32 ? 33 : 33 + (32 - yBytes.length);
        System.arraycopy(yBytes, yStart, uncompressed, yDest, Math.min(yBytes.length, 32));
        return NostrUtil.bytesToHex((byte[])uncompressed);
    }

    public static List<SignedVoucher> extractVouchers(@NonNull GenericEvent event, @NonNull String userPrivkey, @NonNull String userPubkey) {
        BackupPayload payload;
        String decryptedJson;
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (userPrivkey == null) {
            throw new NullPointerException("userPrivkey is marked non-null but is null");
        }
        if (userPubkey == null) {
            throw new NullPointerException("userPubkey is marked non-null but is null");
        }
        if (userPrivkey.isBlank()) {
            throw new IllegalArgumentException("User private key cannot be blank");
        }
        if (userPubkey.isBlank()) {
            throw new IllegalArgumentException("User public key cannot be blank");
        }
        log.debug("Extracting vouchers from backup event");
        if (event.getKind() != KIND_ENCRYPTED_DM) {
            throw new VoucherNostrException("Invalid event kind: expected " + KIND_ENCRYPTED_DM + ", got " + event.getKind());
        }
        String encryptedContent = event.getContent();
        if (encryptedContent == null || encryptedContent.isBlank()) {
            throw new VoucherNostrException("Encrypted content is empty");
        }
        try {
            PublicKey recipientPubKey = new PublicKey(userPubkey);
            byte[] xOnlyBytes = recipientPubKey.getRawData();
            String uncompressedHex = VoucherBackupPayload.convertXOnlyToUncompressed(xOnlyBytes);
            byte[] conversationKey = EncryptedPayloads.getConversationKey((String)userPrivkey, (String)uncompressedHex);
            decryptedJson = EncryptedPayloads.decrypt((String)encryptedContent, (byte[])conversationKey);
            log.debug("Decrypted payload: {} bytes", (Object)decryptedJson.length());
        }
        catch (Exception e) {
            log.error("Failed to decrypt backup payload", (Throwable)e);
            throw new VoucherNostrException("Failed to decrypt backup payload", e);
        }
        try {
            payload = (BackupPayload)objectMapper.readValue(decryptedJson, BackupPayload.class);
            log.debug("Deserialized backup payload: version={}", (Object)payload.getVersion());
        }
        catch (JsonProcessingException e) {
            log.error("Failed to deserialize backup payload", (Throwable)e);
            throw new VoucherNostrException("Failed to deserialize backup payload", e);
        }
        if (!PAYLOAD_VERSION.equals(payload.getVersion())) {
            log.warn("Backup payload version mismatch: expected={}, got={}", (Object)PAYLOAD_VERSION, (Object)payload.getVersion());
        }
        ArrayList<SignedVoucher> vouchers = new ArrayList<SignedVoucher>();
        if (payload.getVouchers() != null) {
            for (VoucherBackupEntry entry : payload.getVouchers()) {
                try {
                    vouchers.add(VoucherEventPayloadMapper.toDomain(entry.getVoucher()));
                }
                catch (IllegalArgumentException ex) {
                    throw new VoucherNostrException("Failed to reconstruct voucher from backup entry", ex);
                }
            }
        }
        log.info("Extracted {} voucher(s) from backup", (Object)vouchers.size());
        return vouchers;
    }

    public static boolean isValidBackupEvent(GenericEvent event) {
        if (event == null) {
            return false;
        }
        return event.getKind() == KIND_ENCRYPTED_DM && event.getContent() != null && !event.getContent().isBlank();
    }

    static {
        Security.removeProvider("BC");
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
    }

    private static class BackupPayload {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="vouchers")
        private List<VoucherBackupEntry> vouchers;
        @JsonProperty(value="metadata")
        private BackupMetadata metadata;

        public String getVersion() {
            return this.version;
        }

        public List<VoucherBackupEntry> getVouchers() {
            return this.vouchers;
        }

        public BackupMetadata getMetadata() {
            return this.metadata;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty(value="vouchers")
        public void setVouchers(List<VoucherBackupEntry> vouchers) {
            this.vouchers = vouchers;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(BackupMetadata metadata) {
            this.metadata = metadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BackupPayload)) {
                return false;
            }
            BackupPayload other = (BackupPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            List<VoucherBackupEntry> this$vouchers = this.getVouchers();
            List<VoucherBackupEntry> other$vouchers = other.getVouchers();
            if (this$vouchers == null ? other$vouchers != null : !((Object)this$vouchers).equals(other$vouchers)) {
                return false;
            }
            BackupMetadata this$metadata = this.getMetadata();
            BackupMetadata other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BackupPayload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            List<VoucherBackupEntry> $vouchers = this.getVouchers();
            result = result * 59 + ($vouchers == null ? 43 : ((Object)$vouchers).hashCode());
            BackupMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            return result;
        }

        public String toString() {
            return "VoucherBackupPayload.BackupPayload(version=" + this.getVersion() + ", vouchers=" + String.valueOf(this.getVouchers()) + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
        }

        public BackupPayload() {
        }

        public BackupPayload(String version, List<VoucherBackupEntry> vouchers, BackupMetadata metadata) {
            this.version = version;
            this.vouchers = vouchers;
            this.metadata = metadata;
        }
    }

    private static class VoucherBackupEntry {
        @JsonProperty(value="voucher")
        private VoucherEventPayloadMapper.VoucherPayload voucher;
        @JsonProperty(value="backedUpAt")
        private Long backedUpAt;

        public VoucherEventPayloadMapper.VoucherPayload getVoucher() {
            return this.voucher;
        }

        public Long getBackedUpAt() {
            return this.backedUpAt;
        }

        @JsonProperty(value="voucher")
        public void setVoucher(VoucherEventPayloadMapper.VoucherPayload voucher) {
            this.voucher = voucher;
        }

        @JsonProperty(value="backedUpAt")
        public void setBackedUpAt(Long backedUpAt) {
            this.backedUpAt = backedUpAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VoucherBackupEntry)) {
                return false;
            }
            VoucherBackupEntry other = (VoucherBackupEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$backedUpAt = this.getBackedUpAt();
            Long other$backedUpAt = other.getBackedUpAt();
            if (this$backedUpAt == null ? other$backedUpAt != null : !((Object)this$backedUpAt).equals(other$backedUpAt)) {
                return false;
            }
            VoucherEventPayloadMapper.VoucherPayload this$voucher = this.getVoucher();
            VoucherEventPayloadMapper.VoucherPayload other$voucher = other.getVoucher();
            return !(this$voucher == null ? other$voucher != null : !this$voucher.equals(other$voucher));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VoucherBackupEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $backedUpAt = this.getBackedUpAt();
            result = result * 59 + ($backedUpAt == null ? 43 : ((Object)$backedUpAt).hashCode());
            VoucherEventPayloadMapper.VoucherPayload $voucher = this.getVoucher();
            result = result * 59 + ($voucher == null ? 43 : $voucher.hashCode());
            return result;
        }

        public String toString() {
            return "VoucherBackupPayload.VoucherBackupEntry(voucher=" + String.valueOf(this.getVoucher()) + ", backedUpAt=" + this.getBackedUpAt() + ")";
        }

        public VoucherBackupEntry() {
        }

        public VoucherBackupEntry(VoucherEventPayloadMapper.VoucherPayload voucher, Long backedUpAt) {
            this.voucher = voucher;
            this.backedUpAt = backedUpAt;
        }
    }

    private static class BackupMetadata {
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonProperty(value="backupTimestamp")
        private Long backupTimestamp;

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public Long getBackupTimestamp() {
            return this.backupTimestamp;
        }

        @JsonProperty(value="totalCount")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="backupTimestamp")
        public void setBackupTimestamp(Long backupTimestamp) {
            this.backupTimestamp = backupTimestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BackupMetadata)) {
                return false;
            }
            BackupMetadata other = (BackupMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$totalCount = this.getTotalCount();
            Integer other$totalCount = other.getTotalCount();
            if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
                return false;
            }
            Long this$backupTimestamp = this.getBackupTimestamp();
            Long other$backupTimestamp = other.getBackupTimestamp();
            return !(this$backupTimestamp == null ? other$backupTimestamp != null : !((Object)this$backupTimestamp).equals(other$backupTimestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BackupMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $totalCount = this.getTotalCount();
            result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
            Long $backupTimestamp = this.getBackupTimestamp();
            result = result * 59 + ($backupTimestamp == null ? 43 : ((Object)$backupTimestamp).hashCode());
            return result;
        }

        public String toString() {
            return "VoucherBackupPayload.BackupMetadata(totalCount=" + this.getTotalCount() + ", backupTimestamp=" + this.getBackupTimestamp() + ")";
        }

        public BackupMetadata() {
        }

        public BackupMetadata(Integer totalCount, Long backupTimestamp) {
            this.totalCount = totalCount;
            this.backupTimestamp = backupTimestamp;
        }
    }
}

