/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.nostr.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import nostr.event.impl.GenericEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.domain.VoucherStatus;
import xyz.tcheeric.cashu.voucher.nostr.VoucherNostrException;
import xyz.tcheeric.cashu.voucher.nostr.events.VoucherEventPayloadMapper;

public class VoucherLedgerEvent
extends GenericEvent {
    private static final Logger log = LoggerFactory.getLogger(VoucherLedgerEvent.class);
    public static final int KIND_VOUCHER_LEDGER = 30078;
    public static final String TAG_STATUS = "status";
    public static final String TAG_AMOUNT = "amount";
    public static final String TAG_UNIT = "unit";
    public static final String TAG_EXPIRY = "expiry";
    public static final String D_TAG_PREFIX = "voucher:";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private List<List<String>> nip01Tags;

    public static VoucherLedgerEvent fromVoucher(SignedVoucher voucher, VoucherStatus status) {
        if (voucher == null) {
            throw new IllegalArgumentException("Voucher cannot be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("Status cannot be null");
        }
        VoucherEventPayloadMapper.VoucherPayload voucherPayload = VoucherEventPayloadMapper.toPayload(voucher);
        String voucherId = voucherPayload.getVoucherId();
        log.debug("Creating VoucherLedgerEvent: voucherId={}, status={}", (Object)voucherId, (Object)status);
        VoucherLedgerEvent event = new VoucherLedgerEvent();
        event.setKind(30078);
        event.setCreatedAt(System.currentTimeMillis() / 1000L);
        ArrayList<List<String>> tagsList = new ArrayList<List<String>>();
        tagsList.add(List.of("d", D_TAG_PREFIX + voucherId));
        tagsList.add(List.of(TAG_STATUS, status.name()));
        tagsList.add(List.of(TAG_AMOUNT, String.valueOf(voucherPayload.getFaceValue())));
        tagsList.add(List.of(TAG_UNIT, voucherPayload.getUnit()));
        if (voucherPayload.getExpiresAt() != null) {
            tagsList.add(List.of(TAG_EXPIRY, String.valueOf(voucherPayload.getExpiresAt())));
        }
        event.setNip01Tags(tagsList);
        try {
            VoucherContent content = new VoucherContent(voucherPayload, status);
            String contentJson = objectMapper.writeValueAsString((Object)content);
            event.setContent(contentJson);
            log.debug("Serialized voucher to event content: {} bytes", (Object)contentJson.length());
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize voucher to JSON: voucherId={}", (Object)voucherId, (Object)e);
            throw new VoucherNostrException("Failed to serialize voucher", e);
        }
        log.debug("Created VoucherLedgerEvent: kind={}, tags={}", (Object)event.getKind(), (Object)tagsList.size());
        return event;
    }

    public SignedVoucher toVoucher() {
        if (this.getKind() != 30078) {
            throw new VoucherNostrException("Invalid event kind: expected 30078, got " + this.getKind());
        }
        log.debug("Extracting voucher from VoucherLedgerEvent: kind={}", (Object)this.getKind());
        String content = this.getContent();
        if (content == null || content.isBlank()) {
            throw new VoucherNostrException("Event content is empty");
        }
        try {
            VoucherContent voucherContent = (VoucherContent)objectMapper.readValue(content, VoucherContent.class);
            log.debug("Deserialized voucher from event content");
            return VoucherEventPayloadMapper.toDomain(voucherContent.getVoucher());
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            log.error("Failed to deserialize voucher from event content", e);
            throw new VoucherNostrException("Failed to deserialize voucher", e);
        }
    }

    public VoucherStatus getStatus() {
        String statusStr = this.getTagValue(TAG_STATUS);
        if (statusStr == null) {
            throw new VoucherNostrException("Status tag not found in event");
        }
        try {
            return VoucherStatus.valueOf((String)statusStr);
        }
        catch (IllegalArgumentException e) {
            throw new VoucherNostrException("Invalid status value: " + statusStr, e);
        }
    }

    public String getVoucherId() {
        String dValue = this.getTagValue("d");
        if (dValue == null) {
            throw new VoucherNostrException("d tag not found in event");
        }
        if (!dValue.startsWith(D_TAG_PREFIX)) {
            throw new VoucherNostrException("d tag does not have expected prefix: " + dValue);
        }
        return dValue.substring(D_TAG_PREFIX.length());
    }

    public Long getAmount() {
        String amountStr = this.getTagValue(TAG_AMOUNT);
        return amountStr != null ? Long.valueOf(Long.parseLong(amountStr)) : null;
    }

    public String getUnit() {
        return this.getTagValue(TAG_UNIT);
    }

    public Long getExpiry() {
        String expiryStr = this.getTagValue(TAG_EXPIRY);
        return expiryStr != null ? Long.valueOf(Long.parseLong(expiryStr)) : null;
    }

    private String getTagValue(String tagName) {
        List<List<String>> tags = this.getNip01Tags();
        if (tags == null) {
            return null;
        }
        for (List<String> tag : tags) {
            if (tag.isEmpty() || !tag.get(0).equals(tagName) || tag.size() <= 1) continue;
            return tag.get(1);
        }
        return null;
    }

    private void setNip01Tags(List<List<String>> tags) {
        this.nip01Tags = tags;
    }

    private List<List<String>> getNip01Tags() {
        return this.nip01Tags;
    }

    public boolean isValid() {
        if (this.getKind() != 30078) {
            return false;
        }
        try {
            String voucherId = this.getVoucherId();
            return voucherId != null && !voucherId.isBlank();
        }
        catch (VoucherNostrException e) {
            return false;
        }
    }

    private static class VoucherContent {
        @JsonProperty(value="voucher")
        private VoucherEventPayloadMapper.VoucherPayload voucher;
        @JsonProperty(value="status")
        private VoucherStatus status;

        public VoucherContent(VoucherEventPayloadMapper.VoucherPayload voucher, VoucherStatus status) {
            this.voucher = voucher;
            this.status = status;
        }

        public VoucherEventPayloadMapper.VoucherPayload getVoucher() {
            return this.voucher;
        }

        public VoucherStatus getStatus() {
            return this.status;
        }

        @JsonProperty(value="voucher")
        public void setVoucher(VoucherEventPayloadMapper.VoucherPayload voucher) {
            this.voucher = voucher;
        }

        @JsonProperty(value="status")
        public void setStatus(VoucherStatus status) {
            this.status = status;
        }

        public VoucherContent() {
        }
    }
}

