/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.nostr.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;

public class NostrRelayConfig {
    public static final long DEFAULT_CONNECTION_TIMEOUT_MS = 5000L;
    public static final long DEFAULT_PUBLISH_TIMEOUT_MS = 5000L;
    public static final long DEFAULT_QUERY_TIMEOUT_MS = 10000L;
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final long DEFAULT_HEALTH_CHECK_INTERVAL_MS = 60000L;
    public static final int DEFAULT_MAX_CONSECUTIVE_FAILURES = 3;
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final List<String> WELL_KNOWN_RELAYS = List.of("wss://relay.damus.io", "wss://relay.snort.social", "wss://nos.lol", "wss://relay.nostr.band", "wss://nostr.wine");
    public static final List<String> CASHU_RELAYS = List.of("wss://relay.damus.io", "wss://relay.cashu.xyz");
    private final List<String> relayUrls;
    private final long connectionTimeoutMs;
    private final int maxRetries;
    private final boolean exponentialBackoff;
    private final long publishTimeoutMs;
    private final long queryTimeoutMs;
    private final int batchSize;
    private final boolean healthCheckEnabled;
    private final long healthCheckIntervalMs;
    private final int maxConsecutiveFailures;
    private final boolean autoReconnect;
    private final boolean requireMinimumRelays;
    private final int minimumRelays;

    public List<String> getRelayUrls() {
        return Collections.unmodifiableList(new ArrayList<String>(this.relayUrls));
    }

    public int getRelayCount() {
        return this.relayUrls.size();
    }

    public boolean hasMinimumRelays() {
        return this.relayUrls.size() >= this.minimumRelays;
    }

    public void validate() {
        if (this.relayUrls.isEmpty()) {
            throw new IllegalStateException("At least one relay URL must be configured");
        }
        if (this.requireMinimumRelays && !this.hasMinimumRelays()) {
            throw new IllegalStateException(String.format("Minimum %d relay(s) required, but only %d configured", this.minimumRelays, this.relayUrls.size()));
        }
        if (this.connectionTimeoutMs <= 0L) {
            throw new IllegalStateException("Connection timeout must be positive");
        }
        if (this.publishTimeoutMs <= 0L) {
            throw new IllegalStateException("Publish timeout must be positive");
        }
        if (this.queryTimeoutMs <= 0L) {
            throw new IllegalStateException("Query timeout must be positive");
        }
        if (this.maxRetries < 0) {
            throw new IllegalStateException("Max retries cannot be negative");
        }
        if (this.healthCheckEnabled && this.healthCheckIntervalMs <= 0L) {
            throw new IllegalStateException("Health check interval must be positive");
        }
        if (this.maxConsecutiveFailures <= 0) {
            throw new IllegalStateException("Max consecutive failures must be positive");
        }
        if (this.batchSize <= 0) {
            throw new IllegalStateException("Batch size must be positive");
        }
        if (this.minimumRelays < 1) {
            throw new IllegalStateException("Minimum relays must be at least 1");
        }
    }

    public static NostrRelayConfig defaultConfig() {
        return NostrRelayConfig.builder().build();
    }

    public static NostrRelayConfig testConfig() {
        return NostrRelayConfig.builder().relayUrls(List.of("ws://localhost:7777")).connectionTimeoutMs(1000L).publishTimeoutMs(1000L).queryTimeoutMs(2000L).maxRetries(1).healthCheckEnabled(false).requireMinimumRelays(false).build();
    }

    public static NostrRelayConfig productionConfig(@NonNull List<String> relayUrls) {
        if (relayUrls == null) {
            throw new NullPointerException("relayUrls is marked non-null but is null");
        }
        return NostrRelayConfig.builder().relayUrls(relayUrls).connectionTimeoutMs(10000L).publishTimeoutMs(8000L).queryTimeoutMs(15000L).maxRetries(5).healthCheckEnabled(true).healthCheckIntervalMs(30000L).requireMinimumRelays(true).minimumRelays(2).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NostrRelayConfig that = (NostrRelayConfig)o;
        return this.connectionTimeoutMs == that.connectionTimeoutMs && this.maxRetries == that.maxRetries && this.exponentialBackoff == that.exponentialBackoff && this.publishTimeoutMs == that.publishTimeoutMs && this.queryTimeoutMs == that.queryTimeoutMs && this.batchSize == that.batchSize && this.healthCheckEnabled == that.healthCheckEnabled && this.healthCheckIntervalMs == that.healthCheckIntervalMs && this.maxConsecutiveFailures == that.maxConsecutiveFailures && this.autoReconnect == that.autoReconnect && this.requireMinimumRelays == that.requireMinimumRelays && this.minimumRelays == that.minimumRelays && Objects.equals(this.relayUrls, that.relayUrls);
    }

    public int hashCode() {
        return Objects.hash(this.relayUrls, this.connectionTimeoutMs, this.maxRetries, this.exponentialBackoff, this.publishTimeoutMs, this.queryTimeoutMs, this.batchSize, this.healthCheckEnabled, this.healthCheckIntervalMs, this.maxConsecutiveFailures, this.autoReconnect, this.requireMinimumRelays, this.minimumRelays);
    }

    private static List<String> $default$relayUrls() {
        return new ArrayList<String>(CASHU_RELAYS);
    }

    private static long $default$connectionTimeoutMs() {
        return 5000L;
    }

    private static int $default$maxRetries() {
        return 3;
    }

    private static boolean $default$exponentialBackoff() {
        return true;
    }

    private static long $default$publishTimeoutMs() {
        return 5000L;
    }

    private static long $default$queryTimeoutMs() {
        return 10000L;
    }

    private static int $default$batchSize() {
        return 100;
    }

    private static boolean $default$healthCheckEnabled() {
        return true;
    }

    private static long $default$healthCheckIntervalMs() {
        return 60000L;
    }

    private static int $default$maxConsecutiveFailures() {
        return 3;
    }

    private static boolean $default$autoReconnect() {
        return true;
    }

    private static boolean $default$requireMinimumRelays() {
        return true;
    }

    private static int $default$minimumRelays() {
        return 1;
    }

    NostrRelayConfig(List<String> relayUrls, long connectionTimeoutMs, int maxRetries, boolean exponentialBackoff, long publishTimeoutMs, long queryTimeoutMs, int batchSize, boolean healthCheckEnabled, long healthCheckIntervalMs, int maxConsecutiveFailures, boolean autoReconnect, boolean requireMinimumRelays, int minimumRelays) {
        this.relayUrls = relayUrls;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.maxRetries = maxRetries;
        this.exponentialBackoff = exponentialBackoff;
        this.publishTimeoutMs = publishTimeoutMs;
        this.queryTimeoutMs = queryTimeoutMs;
        this.batchSize = batchSize;
        this.healthCheckEnabled = healthCheckEnabled;
        this.healthCheckIntervalMs = healthCheckIntervalMs;
        this.maxConsecutiveFailures = maxConsecutiveFailures;
        this.autoReconnect = autoReconnect;
        this.requireMinimumRelays = requireMinimumRelays;
        this.minimumRelays = minimumRelays;
    }

    public static NostrRelayConfigBuilder builder() {
        return new NostrRelayConfigBuilder();
    }

    public NostrRelayConfigBuilder toBuilder() {
        return new NostrRelayConfigBuilder().relayUrls(this.relayUrls).connectionTimeoutMs(this.connectionTimeoutMs).maxRetries(this.maxRetries).exponentialBackoff(this.exponentialBackoff).publishTimeoutMs(this.publishTimeoutMs).queryTimeoutMs(this.queryTimeoutMs).batchSize(this.batchSize).healthCheckEnabled(this.healthCheckEnabled).healthCheckIntervalMs(this.healthCheckIntervalMs).maxConsecutiveFailures(this.maxConsecutiveFailures).autoReconnect(this.autoReconnect).requireMinimumRelays(this.requireMinimumRelays).minimumRelays(this.minimumRelays);
    }

    public long getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public boolean isExponentialBackoff() {
        return this.exponentialBackoff;
    }

    public long getPublishTimeoutMs() {
        return this.publishTimeoutMs;
    }

    public long getQueryTimeoutMs() {
        return this.queryTimeoutMs;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isHealthCheckEnabled() {
        return this.healthCheckEnabled;
    }

    public long getHealthCheckIntervalMs() {
        return this.healthCheckIntervalMs;
    }

    public int getMaxConsecutiveFailures() {
        return this.maxConsecutiveFailures;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public boolean isRequireMinimumRelays() {
        return this.requireMinimumRelays;
    }

    public int getMinimumRelays() {
        return this.minimumRelays;
    }

    public String toString() {
        return "NostrRelayConfig(relayUrls=" + String.valueOf(this.getRelayUrls()) + ", connectionTimeoutMs=" + this.getConnectionTimeoutMs() + ", maxRetries=" + this.getMaxRetries() + ", exponentialBackoff=" + this.isExponentialBackoff() + ", publishTimeoutMs=" + this.getPublishTimeoutMs() + ", queryTimeoutMs=" + this.getQueryTimeoutMs() + ", batchSize=" + this.getBatchSize() + ", healthCheckEnabled=" + this.isHealthCheckEnabled() + ", healthCheckIntervalMs=" + this.getHealthCheckIntervalMs() + ", maxConsecutiveFailures=" + this.getMaxConsecutiveFailures() + ", autoReconnect=" + this.isAutoReconnect() + ", requireMinimumRelays=" + this.isRequireMinimumRelays() + ", minimumRelays=" + this.getMinimumRelays() + ")";
    }

    public static class NostrRelayConfigBuilder {
        private boolean relayUrls$set;
        private List<String> relayUrls$value;
        private boolean connectionTimeoutMs$set;
        private long connectionTimeoutMs$value;
        private boolean maxRetries$set;
        private int maxRetries$value;
        private boolean exponentialBackoff$set;
        private boolean exponentialBackoff$value;
        private boolean publishTimeoutMs$set;
        private long publishTimeoutMs$value;
        private boolean queryTimeoutMs$set;
        private long queryTimeoutMs$value;
        private boolean batchSize$set;
        private int batchSize$value;
        private boolean healthCheckEnabled$set;
        private boolean healthCheckEnabled$value;
        private boolean healthCheckIntervalMs$set;
        private long healthCheckIntervalMs$value;
        private boolean maxConsecutiveFailures$set;
        private int maxConsecutiveFailures$value;
        private boolean autoReconnect$set;
        private boolean autoReconnect$value;
        private boolean requireMinimumRelays$set;
        private boolean requireMinimumRelays$value;
        private boolean minimumRelays$set;
        private int minimumRelays$value;
        private List<String> relayUrls = new ArrayList<String>();

        public NostrRelayConfigBuilder relayUrl(String relayUrl) {
            NostrRelayConfigBuilder.validateRelayUrl(relayUrl);
            if (this.relayUrls == null) {
                this.relayUrls = new ArrayList<String>();
            }
            this.relayUrls.add(relayUrl);
            return this;
        }

        public NostrRelayConfigBuilder relayUrls(List<String> relayUrls) {
            if (relayUrls != null) {
                relayUrls.forEach(NostrRelayConfigBuilder::validateRelayUrl);
                this.relayUrls = new ArrayList<String>(relayUrls);
            }
            return this;
        }

        public NostrRelayConfigBuilder useWellKnownRelays() {
            this.relayUrls = new ArrayList<String>(WELL_KNOWN_RELAYS);
            return this;
        }

        public NostrRelayConfigBuilder useCashuRelays() {
            this.relayUrls = new ArrayList<String>(CASHU_RELAYS);
            return this;
        }

        private static void validateRelayUrl(String url) {
            if (url == null || url.isBlank()) {
                throw new IllegalArgumentException("Relay URL cannot be null or blank");
            }
            try {
                URI uri = new URI(url);
                String scheme = uri.getScheme();
                if (!"wss".equals(scheme) && !"ws".equals(scheme)) {
                    throw new IllegalArgumentException("Relay URL must use wss:// or ws:// scheme: " + url);
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid relay URL: " + url, e);
            }
        }

        NostrRelayConfigBuilder() {
        }

        public NostrRelayConfigBuilder connectionTimeoutMs(long connectionTimeoutMs) {
            this.connectionTimeoutMs$value = connectionTimeoutMs;
            this.connectionTimeoutMs$set = true;
            return this;
        }

        public NostrRelayConfigBuilder maxRetries(int maxRetries) {
            this.maxRetries$value = maxRetries;
            this.maxRetries$set = true;
            return this;
        }

        public NostrRelayConfigBuilder exponentialBackoff(boolean exponentialBackoff) {
            this.exponentialBackoff$value = exponentialBackoff;
            this.exponentialBackoff$set = true;
            return this;
        }

        public NostrRelayConfigBuilder publishTimeoutMs(long publishTimeoutMs) {
            this.publishTimeoutMs$value = publishTimeoutMs;
            this.publishTimeoutMs$set = true;
            return this;
        }

        public NostrRelayConfigBuilder queryTimeoutMs(long queryTimeoutMs) {
            this.queryTimeoutMs$value = queryTimeoutMs;
            this.queryTimeoutMs$set = true;
            return this;
        }

        public NostrRelayConfigBuilder batchSize(int batchSize) {
            this.batchSize$value = batchSize;
            this.batchSize$set = true;
            return this;
        }

        public NostrRelayConfigBuilder healthCheckEnabled(boolean healthCheckEnabled) {
            this.healthCheckEnabled$value = healthCheckEnabled;
            this.healthCheckEnabled$set = true;
            return this;
        }

        public NostrRelayConfigBuilder healthCheckIntervalMs(long healthCheckIntervalMs) {
            this.healthCheckIntervalMs$value = healthCheckIntervalMs;
            this.healthCheckIntervalMs$set = true;
            return this;
        }

        public NostrRelayConfigBuilder maxConsecutiveFailures(int maxConsecutiveFailures) {
            this.maxConsecutiveFailures$value = maxConsecutiveFailures;
            this.maxConsecutiveFailures$set = true;
            return this;
        }

        public NostrRelayConfigBuilder autoReconnect(boolean autoReconnect) {
            this.autoReconnect$value = autoReconnect;
            this.autoReconnect$set = true;
            return this;
        }

        public NostrRelayConfigBuilder requireMinimumRelays(boolean requireMinimumRelays) {
            this.requireMinimumRelays$value = requireMinimumRelays;
            this.requireMinimumRelays$set = true;
            return this;
        }

        public NostrRelayConfigBuilder minimumRelays(int minimumRelays) {
            this.minimumRelays$value = minimumRelays;
            this.minimumRelays$set = true;
            return this;
        }

        public NostrRelayConfig build() {
            List<String> relayUrls$value = this.relayUrls$value;
            if (!this.relayUrls$set) {
                relayUrls$value = NostrRelayConfig.$default$relayUrls();
            }
            long connectionTimeoutMs$value = this.connectionTimeoutMs$value;
            if (!this.connectionTimeoutMs$set) {
                connectionTimeoutMs$value = NostrRelayConfig.$default$connectionTimeoutMs();
            }
            int maxRetries$value = this.maxRetries$value;
            if (!this.maxRetries$set) {
                maxRetries$value = NostrRelayConfig.$default$maxRetries();
            }
            boolean exponentialBackoff$value = this.exponentialBackoff$value;
            if (!this.exponentialBackoff$set) {
                exponentialBackoff$value = NostrRelayConfig.$default$exponentialBackoff();
            }
            long publishTimeoutMs$value = this.publishTimeoutMs$value;
            if (!this.publishTimeoutMs$set) {
                publishTimeoutMs$value = NostrRelayConfig.$default$publishTimeoutMs();
            }
            long queryTimeoutMs$value = this.queryTimeoutMs$value;
            if (!this.queryTimeoutMs$set) {
                queryTimeoutMs$value = NostrRelayConfig.$default$queryTimeoutMs();
            }
            int batchSize$value = this.batchSize$value;
            if (!this.batchSize$set) {
                batchSize$value = NostrRelayConfig.$default$batchSize();
            }
            boolean healthCheckEnabled$value = this.healthCheckEnabled$value;
            if (!this.healthCheckEnabled$set) {
                healthCheckEnabled$value = NostrRelayConfig.$default$healthCheckEnabled();
            }
            long healthCheckIntervalMs$value = this.healthCheckIntervalMs$value;
            if (!this.healthCheckIntervalMs$set) {
                healthCheckIntervalMs$value = NostrRelayConfig.$default$healthCheckIntervalMs();
            }
            int maxConsecutiveFailures$value = this.maxConsecutiveFailures$value;
            if (!this.maxConsecutiveFailures$set) {
                maxConsecutiveFailures$value = NostrRelayConfig.$default$maxConsecutiveFailures();
            }
            boolean autoReconnect$value = this.autoReconnect$value;
            if (!this.autoReconnect$set) {
                autoReconnect$value = NostrRelayConfig.$default$autoReconnect();
            }
            boolean requireMinimumRelays$value = this.requireMinimumRelays$value;
            if (!this.requireMinimumRelays$set) {
                requireMinimumRelays$value = NostrRelayConfig.$default$requireMinimumRelays();
            }
            int minimumRelays$value = this.minimumRelays$value;
            if (!this.minimumRelays$set) {
                minimumRelays$value = NostrRelayConfig.$default$minimumRelays();
            }
            return new NostrRelayConfig(relayUrls$value, connectionTimeoutMs$value, maxRetries$value, exponentialBackoff$value, publishTimeoutMs$value, queryTimeoutMs$value, batchSize$value, healthCheckEnabled$value, healthCheckIntervalMs$value, maxConsecutiveFailures$value, autoReconnect$value, requireMinimumRelays$value, minimumRelays$value);
        }

        public String toString() {
            return "NostrRelayConfig.NostrRelayConfigBuilder(relayUrls$value=" + String.valueOf(this.relayUrls$value) + ", connectionTimeoutMs$value=" + this.connectionTimeoutMs$value + ", maxRetries$value=" + this.maxRetries$value + ", exponentialBackoff$value=" + this.exponentialBackoff$value + ", publishTimeoutMs$value=" + this.publishTimeoutMs$value + ", queryTimeoutMs$value=" + this.queryTimeoutMs$value + ", batchSize$value=" + this.batchSize$value + ", healthCheckEnabled$value=" + this.healthCheckEnabled$value + ", healthCheckIntervalMs$value=" + this.healthCheckIntervalMs$value + ", maxConsecutiveFailures$value=" + this.maxConsecutiveFailures$value + ", autoReconnect$value=" + this.autoReconnect$value + ", requireMinimumRelays$value=" + this.requireMinimumRelays$value + ", minimumRelays$value=" + this.minimumRelays$value + ")";
        }
    }
}

