/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.voucher.nostr.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import nostr.util.NostrUtil;
import xyz.tcheeric.cashu.voucher.domain.BackingStrategy;
import xyz.tcheeric.cashu.voucher.domain.SignedVoucher;
import xyz.tcheeric.cashu.voucher.domain.VoucherSecret;

final class VoucherEventPayloadMapper {
    private VoucherEventPayloadMapper() {
    }

    static VoucherPayload toPayload(SignedVoucher voucher) {
        Objects.requireNonNull(voucher, "voucher");
        VoucherSecret secret = voucher.getSecret();
        VoucherPayload payload = new VoucherPayload();
        payload.setVoucherId(secret.getVoucherId());
        payload.setIssuerId(secret.getIssuerId());
        payload.setUnit(secret.getUnit());
        payload.setFaceValue(secret.getFaceValue());
        payload.setExpiresAt(secret.getExpiresAt());
        payload.setMemo(secret.getMemo());
        payload.setBackingStrategy(secret.getBackingStrategy().name());
        payload.setIssuanceRatio(secret.getIssuanceRatio());
        payload.setFaceDecimals(secret.getFaceDecimals());
        payload.setMerchantMetadata(secret.getMerchantMetadata());
        payload.setIssuerSignature(NostrUtil.bytesToHex((byte[])voucher.getIssuerSignature()));
        payload.setIssuerPublicKey(voucher.getIssuerPublicKey());
        return payload;
    }

    static SignedVoucher toDomain(VoucherPayload payload) {
        Objects.requireNonNull(payload, "payload");
        BackingStrategy backingStrategy = payload.getBackingStrategy() != null ? BackingStrategy.valueOf((String)payload.getBackingStrategy()) : BackingStrategy.FIXED;
        VoucherSecret secret = VoucherSecret.create((String)Objects.requireNonNull(payload.getVoucherId(), "voucherId"), (String)Objects.requireNonNull(payload.getIssuerId(), "issuerId"), (String)Objects.requireNonNull(payload.getUnit(), "unit"), (long)payload.getFaceValue(), (Long)payload.getExpiresAt(), (String)payload.getMemo(), (BackingStrategy)backingStrategy, (double)(payload.getIssuanceRatio() > 0.0 ? payload.getIssuanceRatio() : 1.0), (int)payload.getFaceDecimals(), payload.getMerchantMetadata());
        String signatureHex = Objects.requireNonNull(payload.getIssuerSignature(), "issuerSignature");
        byte[] signatureBytes = NostrUtil.hex128ToBytes((String)signatureHex);
        String publicKey = Objects.requireNonNull(payload.getIssuerPublicKey(), "issuerPublicKey");
        return new SignedVoucher(secret, signatureBytes, publicKey);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static final class VoucherPayload {
        @JsonProperty(value="voucherId")
        private String voucherId;
        @JsonProperty(value="issuerId")
        private String issuerId;
        @JsonProperty(value="unit")
        private String unit;
        @JsonProperty(value="faceValue")
        private long faceValue;
        @JsonProperty(value="expiresAt")
        private Long expiresAt;
        @JsonProperty(value="memo")
        private String memo;
        @JsonProperty(value="backingStrategy")
        private String backingStrategy;
        @JsonProperty(value="issuanceRatio")
        private double issuanceRatio;
        @JsonProperty(value="faceDecimals")
        private int faceDecimals;
        @JsonProperty(value="merchantMetadata")
        private Map<String, Object> merchantMetadata;
        @JsonProperty(value="issuerSignature")
        private String issuerSignature;
        @JsonProperty(value="issuerPublicKey")
        private String issuerPublicKey;

        public String getVoucherId() {
            return this.voucherId;
        }

        public String getIssuerId() {
            return this.issuerId;
        }

        public String getUnit() {
            return this.unit;
        }

        public long getFaceValue() {
            return this.faceValue;
        }

        public Long getExpiresAt() {
            return this.expiresAt;
        }

        public String getMemo() {
            return this.memo;
        }

        public String getBackingStrategy() {
            return this.backingStrategy;
        }

        public double getIssuanceRatio() {
            return this.issuanceRatio;
        }

        public int getFaceDecimals() {
            return this.faceDecimals;
        }

        public Map<String, Object> getMerchantMetadata() {
            return this.merchantMetadata;
        }

        public String getIssuerSignature() {
            return this.issuerSignature;
        }

        public String getIssuerPublicKey() {
            return this.issuerPublicKey;
        }

        @JsonProperty(value="voucherId")
        public void setVoucherId(String voucherId) {
            this.voucherId = voucherId;
        }

        @JsonProperty(value="issuerId")
        public void setIssuerId(String issuerId) {
            this.issuerId = issuerId;
        }

        @JsonProperty(value="unit")
        public void setUnit(String unit) {
            this.unit = unit;
        }

        @JsonProperty(value="faceValue")
        public void setFaceValue(long faceValue) {
            this.faceValue = faceValue;
        }

        @JsonProperty(value="expiresAt")
        public void setExpiresAt(Long expiresAt) {
            this.expiresAt = expiresAt;
        }

        @JsonProperty(value="memo")
        public void setMemo(String memo) {
            this.memo = memo;
        }

        @JsonProperty(value="backingStrategy")
        public void setBackingStrategy(String backingStrategy) {
            this.backingStrategy = backingStrategy;
        }

        @JsonProperty(value="issuanceRatio")
        public void setIssuanceRatio(double issuanceRatio) {
            this.issuanceRatio = issuanceRatio;
        }

        @JsonProperty(value="faceDecimals")
        public void setFaceDecimals(int faceDecimals) {
            this.faceDecimals = faceDecimals;
        }

        @JsonProperty(value="merchantMetadata")
        public void setMerchantMetadata(Map<String, Object> merchantMetadata) {
            this.merchantMetadata = merchantMetadata;
        }

        @JsonProperty(value="issuerSignature")
        public void setIssuerSignature(String issuerSignature) {
            this.issuerSignature = issuerSignature;
        }

        @JsonProperty(value="issuerPublicKey")
        public void setIssuerPublicKey(String issuerPublicKey) {
            this.issuerPublicKey = issuerPublicKey;
        }
    }
}

