/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.proto.tasks;

import java.math.BigInteger;
import java.util.logging.Logger;
import lombok.Generated;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.Signature;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.crypto.util.Utils;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.wallet.proto.service.BDHKEUtilsService;
import xyz.tcheeric.cashu.wallet.proto.service.BDHKEUtilsServiceImpl;

@Nut(value=4)
public class UnblindSignatureTask<T extends Secret>
implements Task<Proof<T>> {
    @Generated
    private static final Logger log = Logger.getLogger(UnblindSignatureTask.class.getName());
    private final BlindSignature blindSignature;
    private final BigInteger r;
    private final PublicKey K;
    private final T secret;
    private final BDHKEUtilsService utilsService;

    public UnblindSignatureTask(BlindSignature blindSignature, BigInteger r, PublicKey K, T secret) {
        this(blindSignature, r, K, secret, new BDHKEUtilsServiceImpl());
    }

    public Proof<T> execute() {
        Signature C_ = this.blindSignature.getBlindedSignature();
        byte[] C = this.utilsService.unblindSignature(C_.getBytes(), Utils.bytesFromBigInteger((BigInteger)this.r), this.K.getBytes());
        Proof.builder().build();
        return Proof.builder().secret(this.secret).amount(this.blindSignature.getAmount()).keySetId(this.blindSignature.getKeySetId().toString()).unblindedSignature(Signature.fromBytes((byte[])C)).build();
    }

    @Generated
    public UnblindSignatureTask(BlindSignature blindSignature, BigInteger r, PublicKey K, T secret, BDHKEUtilsService utilsService) {
        this.blindSignature = blindSignature;
        this.r = r;
        this.K = K;
        this.secret = secret;
        this.utilsService = utilsService;
    }

    @Generated
    public String toString() {
        return "UnblindSignatureTask(blindSignature=" + String.valueOf(this.blindSignature) + ", r=" + String.valueOf(this.r) + ", K=" + String.valueOf(this.K) + ", secret=" + String.valueOf(this.secret) + ", utilsService=" + String.valueOf(this.utilsService) + ")";
    }
}

