/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.proto.mnemonic;

import lombok.Generated;
import lombok.NonNull;
import org.bitcoinj.crypto.DeterministicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.bips.bip39.Bip39;
import xyz.tcheeric.bips.bip39.MnemonicValidator;
import xyz.tcheeric.cashu.entities.annotation.Nut;

@Nut(value=13)
public final class MnemonicManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MnemonicManager.class);
    public static final int DEFAULT_WORD_COUNT = 12;
    public static final int[] VALID_WORD_COUNTS = new int[]{12, 15, 18, 21, 24};

    private MnemonicManager() {
        throw new AssertionError((Object)"MnemonicManager is a utility class and should not be instantiated");
    }

    public static String generateMnemonic() {
        return MnemonicManager.generateMnemonic(12);
    }

    public static String generateMnemonic(int wordCount) {
        MnemonicManager.validateWordCount(wordCount);
        log.info("mnemonic_generation_started word_count={}", (Object)wordCount);
        try {
            String mnemonic = Bip39.generateMnemonic((int)wordCount);
            log.info("mnemonic_generation_completed word_count={} entropy_bits={}", (Object)wordCount, (Object)MnemonicManager.calculateEntropyBits(wordCount));
            return mnemonic;
        }
        catch (Exception e) {
            log.error("mnemonic_generation_failed word_count={} error={}", (Object)wordCount, (Object)e.getMessage());
            throw new IllegalStateException("Failed to generate mnemonic: " + e.getMessage(), e);
        }
    }

    public static boolean validateMnemonic(@NonNull String mnemonic) {
        if (mnemonic == null) {
            throw new NullPointerException("mnemonic is marked non-null but is null");
        }
        log.debug("mnemonic_validation_started");
        boolean isValid = Bip39.isValidMnemonic((String)mnemonic);
        log.debug("mnemonic_validation_completed valid={}", (Object)isValid);
        return isValid;
    }

    public static ValidationResult validateMnemonicWithDetails(@NonNull String mnemonic) {
        if (mnemonic == null) {
            throw new NullPointerException("mnemonic is marked non-null but is null");
        }
        log.debug("mnemonic_detailed_validation_started");
        try {
            MnemonicValidator.ValidationResult result = Bip39.validateMnemonic((String)mnemonic);
            log.debug("mnemonic_detailed_validation_completed valid={} error={}", (Object)result.isValid(), (Object)result.getErrorMessage());
            return new ValidationResult(result.isValid(), result.getErrorMessage());
        }
        catch (Exception e) {
            log.error("mnemonic_detailed_validation_error error={}", (Object)e.getMessage());
            return new ValidationResult(false, "Validation error: " + e.getMessage());
        }
    }

    public static DeterministicKey loadFromMnemonic(@NonNull String mnemonic, @NonNull String passphrase) {
        if (mnemonic == null) {
            throw new NullPointerException("mnemonic is marked non-null but is null");
        }
        if (passphrase == null) {
            throw new NullPointerException("passphrase is marked non-null but is null");
        }
        log.debug("master_key_derivation_started");
        if (!MnemonicManager.validateMnemonic(mnemonic)) {
            ValidationResult result = MnemonicManager.validateMnemonicWithDetails(mnemonic);
            log.error("master_key_derivation_failed_invalid_mnemonic error={}", (Object)result.getErrorMessage());
            throw new IllegalArgumentException("Invalid mnemonic phrase: " + result.getErrorMessage());
        }
        try {
            DeterministicKey masterKey = Bip39.mnemonicToMasterKey((String)mnemonic, (String)passphrase);
            log.info("master_key_derivation_completed has_passphrase={}", (Object)(!passphrase.isEmpty() ? 1 : 0));
            return masterKey;
        }
        catch (Exception e) {
            log.error("master_key_derivation_failed error={}", (Object)e.getMessage());
            throw new IllegalStateException("Failed to derive master key: " + e.getMessage(), e);
        }
    }

    public static DeterministicKey loadFromMnemonicUnsafe(@NonNull String mnemonic, @NonNull String passphrase) {
        if (mnemonic == null) {
            throw new NullPointerException("mnemonic is marked non-null but is null");
        }
        if (passphrase == null) {
            throw new NullPointerException("passphrase is marked non-null but is null");
        }
        log.debug("master_key_derivation_unsafe_started");
        try {
            DeterministicKey masterKey = Bip39.mnemonicToMasterKey((String)mnemonic, (String)passphrase);
            log.info("master_key_derivation_unsafe_completed");
            return masterKey;
        }
        catch (Exception e) {
            log.error("master_key_derivation_unsafe_failed error={}", (Object)e.getMessage());
            throw new IllegalStateException("Failed to derive master key: " + e.getMessage(), e);
        }
    }

    public static String normalizeMnemonic(@NonNull String mnemonic) {
        if (mnemonic == null) {
            throw new NullPointerException("mnemonic is marked non-null but is null");
        }
        return mnemonic.trim().toLowerCase().replaceAll("\\s+", " ");
    }

    public static int getWordCount(@NonNull String mnemonic) {
        if (mnemonic == null) {
            throw new NullPointerException("mnemonic is marked non-null but is null");
        }
        String normalized = MnemonicManager.normalizeMnemonic(mnemonic);
        if (normalized.isEmpty()) {
            return 0;
        }
        return normalized.split(" ").length;
    }

    public static boolean isValidWordCount(int wordCount) {
        for (int validCount : VALID_WORD_COUNTS) {
            if (wordCount != validCount) continue;
            return true;
        }
        return false;
    }

    public static int calculateEntropyBits(int wordCount) {
        MnemonicManager.validateWordCount(wordCount);
        return wordCount * 11 * 32 / 33;
    }

    private static void validateWordCount(int wordCount) {
        if (!MnemonicManager.isValidWordCount(wordCount)) {
            throw new IllegalArgumentException(String.format("Invalid word count: %d. Must be one of: 12, 15, 18, 21, or 24", wordCount));
        }
    }

    public static class ValidationResult {
        private final boolean valid;
        private final String errorMessage;

        public ValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessage() {
            return this.errorMessage != null ? this.errorMessage : "";
        }

        public String toString() {
            return this.valid ? "ValidationResult{valid=true}" : String.format("ValidationResult{valid=false, error='%s'}", this.errorMessage);
        }
    }
}

