/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.proto.service;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.DeterministicSecret;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.crypto.util.Utils;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.entities.rest.PostRestoreResponse;
import xyz.tcheeric.cashu.wallet.proto.service.BDHKEUtilsService;
import xyz.tcheeric.cashu.wallet.proto.service.BDHKEUtilsServiceImpl;
import xyz.tcheeric.cashu.wallet.proto.service.ProofRecoveryService;
import xyz.tcheeric.cashu.wallet.proto.tasks.UnblindSignatureTask;

@Nut(value=9)
public class ProofRecoveryServiceImpl
implements ProofRecoveryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProofRecoveryServiceImpl.class);
    private final BDHKEUtilsService bdkhUtils;

    public ProofRecoveryServiceImpl() {
        this(new BDHKEUtilsServiceImpl());
    }

    @Override
    public List<Proof<DeterministicSecret>> unblindAndCreateProofs(@NonNull PostRestoreResponse response, @NonNull List<DeterministicSecret> secrets, @NonNull List<byte[]> blindingFactors, @NonNull KeySet keySet) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (secrets == null) {
            throw new NullPointerException("secrets is marked non-null but is null");
        }
        if (blindingFactors == null) {
            throw new NullPointerException("blindingFactors is marked non-null but is null");
        }
        if (keySet == null) {
            throw new NullPointerException("keySet is marked non-null but is null");
        }
        if (secrets.size() != blindingFactors.size()) {
            throw new IllegalArgumentException(String.format("Secrets and blinding factors count mismatch: secrets=%d, blindingFactors=%d", secrets.size(), blindingFactors.size()));
        }
        List blindSignatures = response.getBlindSignatures();
        if (blindSignatures == null || blindSignatures.isEmpty()) {
            log.info("proof_recovery response_empty keyset={} action=skip_unblinding", (Object)keySet.getId());
            return List.of();
        }
        log.info("proof_recovery unblinding_started keyset={} signatures_count={} secrets_count={}", new Object[]{keySet.getId(), blindSignatures.size(), secrets.size()});
        ArrayList<Proof<DeterministicSecret>> proofs = new ArrayList<Proof<DeterministicSecret>>(blindSignatures.size());
        for (int i = 0; i < blindSignatures.size() && i < secrets.size(); ++i) {
            BlindSignature blindSig = (BlindSignature)blindSignatures.get(i);
            DeterministicSecret secret = secrets.get(i);
            byte[] blindingFactor = blindingFactors.get(i);
            try {
                if (blindingFactor == null || blindingFactor.length != 32) {
                    log.warn("proof_recovery blinding_factor_invalid index={} counter={} action=skip_signature", (Object)i, (Object)secret.getCounter());
                    continue;
                }
                PublicKey publicKey = keySet.getKeys().get(blindSig.getAmount());
                if (publicKey == null) {
                    log.warn("proof_recovery public_key_missing index={} amount={} counter={} action=skip_signature", new Object[]{i, blindSig.getAmount(), secret.getCounter()});
                    continue;
                }
                BigInteger r = Utils.bigIntFromBytes((byte[])blindingFactor);
                UnblindSignatureTask<DeterministicSecret> unblindTask = new UnblindSignatureTask<DeterministicSecret>(blindSig, r, publicKey, secret, this.bdkhUtils);
                Proof<DeterministicSecret> proof = unblindTask.execute();
                proofs.add(proof);
                log.debug("proof_recovery unblinding_success index={} amount={} counter={} keyset={}", new Object[]{i, proof.getAmount(), secret.getCounter(), proof.getKeySetId()});
                continue;
            }
            catch (Exception e) {
                log.error("proof_recovery unblinding_failed index={} counter={} error={} impact=continuing_batch", new Object[]{i, secret.getCounter(), e.getMessage(), e});
            }
        }
        log.info("proof_recovery unblinding_completed keyset={} recovered_count={}", (Object)keySet.getId(), (Object)proofs.size());
        return proofs;
    }

    @Override
    public List<Proof<DeterministicSecret>> filterUnspentProofs(@NonNull List<Proof<DeterministicSecret>> proofs, @NonNull String mintUrl) {
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        log.warn("proof_recovery spent_check_unimplemented mint_url={} action=return_all", (Object)mintUrl);
        return proofs;
    }

    @Generated
    public ProofRecoveryServiceImpl(BDHKEUtilsService bdkhUtils) {
        this.bdkhUtils = bdkhUtils;
    }

    @Generated
    public String toString() {
        return "ProofRecoveryServiceImpl(bdkhUtils=" + String.valueOf(this.bdkhUtils) + ")";
    }
}

