/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.wallet.proto.tasks;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bitcoinj.crypto.DeterministicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.bips.bip32.nut.Nut13Derivation;
import xyz.tcheeric.cashu.common.DeterministicSecret;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.annotation.Nut;

@Nut(value=13)
public class DeriveSecretsTask
implements Task<DeriveSecretsResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeriveSecretsTask.class);
    private final DeterministicKey masterKey;
    private final KeysetId keysetId;
    private final int startCounter;
    private final int count;

    public DeriveSecretsResult execute() {
        log.info("derive_secrets task_started keyset={} start_counter={} count={}", new Object[]{this.keysetId, this.startCounter, this.count});
        ArrayList<DeterministicSecret> secrets = new ArrayList<DeterministicSecret>(this.count);
        ArrayList<byte[]> blindingFactors = new ArrayList<byte[]>(this.count);
        String keysetIdHex = this.keysetId.toString();
        for (int i = 0; i < this.count; ++i) {
            int counter = this.startCounter + i;
            try {
                Nut13Derivation.SecretAndBlindingFactor pair = Nut13Derivation.deriveSecretAndBlindingFactor((DeterministicKey)this.masterKey, (String)keysetIdHex, (int)counter);
                DeterministicSecret secret = DeterministicSecret.create((byte[])pair.secret(), (KeysetId)this.keysetId, (int)counter);
                secrets.add(secret);
                blindingFactors.add(pair.blindingFactor());
                continue;
            }
            catch (Exception e) {
                log.error("derive_secrets task_failed keyset={} counter={} error={} impact=abort_batch", new Object[]{this.keysetId, counter, e.getMessage(), e});
                throw new IllegalStateException(String.format("Failed to derive secret at counter %d: %s", counter, e.getMessage()), e);
            }
        }
        log.info("derive_secrets task_completed keyset={} derived_count={}", (Object)this.keysetId, (Object)secrets.size());
        return new DeriveSecretsResult(secrets, blindingFactors);
    }

    @Generated
    public DeriveSecretsTask(DeterministicKey masterKey, KeysetId keysetId, int startCounter, int count) {
        this.masterKey = masterKey;
        this.keysetId = keysetId;
        this.startCounter = startCounter;
        this.count = count;
    }

    @Generated
    public String toString() {
        return "DeriveSecretsTask(keysetId=" + String.valueOf(this.keysetId) + ", startCounter=" + this.startCounter + ", count=" + this.count + ")";
    }

    public static class DeriveSecretsResult {
        private final List<DeterministicSecret> secrets;
        private final List<byte[]> blindingFactors;

        public int getCount() {
            return this.secrets.size();
        }

        public void validate() {
            if (this.secrets.size() != this.blindingFactors.size()) {
                throw new IllegalStateException(String.format("Secrets and blinding factors count mismatch: secrets=%d, blindingFactors=%d", this.secrets.size(), this.blindingFactors.size()));
            }
        }

        @Generated
        public List<DeterministicSecret> getSecrets() {
            return this.secrets;
        }

        @Generated
        public List<byte[]> getBlindingFactors() {
            return this.blindingFactors;
        }

        @Generated
        public DeriveSecretsResult(List<DeterministicSecret> secrets, List<byte[]> blindingFactors) {
            this.secrets = secrets;
            this.blindingFactors = blindingFactors;
        }

        @Generated
        public String toString() {
            return "DeriveSecretsTask.DeriveSecretsResult(secrets=" + String.valueOf(this.getSecrets()) + ", blindingFactors=" + String.valueOf(this.getBlindingFactors()) + ")";
        }
    }
}

