/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import jakarta.annotation.PostConstruct;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import xyz.tcheeric.gateway.app.config.GatewaySecurityApiKeysProperties;
import xyz.tcheeric.gateway.app.security.ConfigurableApiKeyStore;
import xyz.tcheeric.gateway.security.auth.ApiKeyStore;

@Component
public class ApiKeyInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiKeyInitializer.class);
    private final GatewaySecurityApiKeysProperties properties;
    private final ApiKeyStore apiKeyStore;

    public ApiKeyInitializer(GatewaySecurityApiKeysProperties properties, ApiKeyStore apiKeyStore) {
        this.properties = properties;
        this.apiKeyStore = apiKeyStore;
    }

    @PostConstruct
    void initializeApiKeys() {
        ApiKeyStore apiKeyStore = this.apiKeyStore;
        if (!(apiKeyStore instanceof ConfigurableApiKeyStore)) {
            LOGGER.info("api_key_initializer_skipped reason=store_not_configurable store_type={}", (Object)this.apiKeyStore.getClass().getSimpleName());
            return;
        }
        ConfigurableApiKeyStore configurableStore = (ConfigurableApiKeyStore)apiKeyStore;
        if (this.properties.getApiKeys() == null || this.properties.getApiKeys().isEmpty()) {
            LOGGER.info("api_key_initializer_skipped reason=no_preconfigured_keys");
            return;
        }
        int initialized = 0;
        for (GatewaySecurityApiKeysProperties.ApiKeyEntry entry : this.properties.getApiKeys()) {
            if (!entry.isEnabled()) {
                LOGGER.debug("api_key_skipped id={} reason=disabled", (Object)entry.getId());
                continue;
            }
            if (entry.getKey() == null || entry.getKey().isBlank()) {
                LOGGER.warn("api_key_skipped id={} reason=missing_key", (Object)entry.getId());
                continue;
            }
            HashSet scopes = new HashSet(entry.getScopes());
            configurableStore.registerKey(entry.getId(), entry.getKey(), entry.getSecret(), scopes, entry.getRateLimit());
            ++initialized;
            LOGGER.info("api_key_registered id={} scopes={} rate_limit={}", new Object[]{entry.getId(), scopes.size(), entry.getRateLimit()});
        }
        LOGGER.info("api_key_initialization_complete count={}", (Object)initialized);
    }
}

