/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.crypto.password.PasswordEncoder;
import xyz.tcheeric.gateway.app.config.GatewayApiKeyProperties;
import xyz.tcheeric.gateway.app.persistence.PostgresApiKeyRepository;
import xyz.tcheeric.gateway.app.persistence.PostgresApiKeyStore;
import xyz.tcheeric.gateway.app.security.ConfigurableApiKeyStore;
import xyz.tcheeric.gateway.app.security.SecureApiKeyStore;
import xyz.tcheeric.gateway.rest.apikey.ApiKeyRepository;
import xyz.tcheeric.gateway.security.auth.ApiKeyStore;

@Configuration
public class ApiKeyPersistenceConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiKeyPersistenceConfiguration.class);

    @Bean(name={"apiKeyDataSource"})
    @ConditionalOnProperty(name={"gateway.api-keys.database.enabled"}, havingValue="true")
    public DataSource apiKeyDataSource(GatewayApiKeyProperties properties) {
        GatewayApiKeyProperties.Database dbProps = properties.getDatabase();
        LOGGER.info("api_key_persistence configuring_datasource url={}", (Object)dbProps.getUrl());
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(dbProps.getUrl());
        config.setUsername(dbProps.getUsername());
        config.setPassword(dbProps.getPassword());
        config.setMaximumPoolSize(dbProps.getMaximumPoolSize());
        config.setConnectionTimeout(dbProps.getConnectionTimeout().toMillis());
        config.setPoolName("ApiKeyPool");
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        return new HikariDataSource(config);
    }

    @Bean(name={"apiKeyFlyway"})
    @ConditionalOnProperty(name={"gateway.api-keys.database.enabled"}, havingValue="true")
    public Flyway apiKeyFlyway(DataSource apiKeyDataSource, GatewayApiKeyProperties properties) {
        LOGGER.info("api_key_persistence running_flyway_migrations location={}", (Object)properties.getDatabase().getMigrationLocations());
        Flyway flyway = Flyway.configure().dataSource(apiKeyDataSource).locations(new String[]{properties.getDatabase().getMigrationLocations()}).baselineOnMigrate(true).baselineVersion("0").outOfOrder(true).load();
        flyway.migrate();
        LOGGER.info("api_key_persistence flyway_migrations_complete");
        return flyway;
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.api-keys.database.enabled"}, havingValue="true")
    public ApiKeyRepository postgresApiKeyRepository(DataSource apiKeyDataSource, Flyway apiKeyFlyway) {
        return new PostgresApiKeyRepository(apiKeyDataSource);
    }

    @Bean
    @Primary
    @ConditionalOnProperty(name={"gateway.api-keys.database.enabled"}, havingValue="true")
    public ApiKeyStore postgresApiKeyStore(ApiKeyRepository apiKeyRepository, PasswordEncoder passwordEncoder, GatewayApiKeyProperties properties) {
        LOGGER.info("api_key_persistence creating_postgres_store");
        return new PostgresApiKeyStore(apiKeyRepository, passwordEncoder, properties.getMasterKey());
    }

    @Bean
    @ConditionalOnMissingBean(value={ApiKeyStore.class})
    public ConfigurableApiKeyStore inMemoryApiKeyStore(GatewayApiKeyProperties properties, PasswordEncoder passwordEncoder) {
        LOGGER.info("api_key_persistence creating_in_memory_store");
        return new SecureApiKeyStore(properties.getMasterKey(), passwordEncoder);
    }
}

