/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import xyz.tcheeric.gateway.app.config.GatewayApiKeyProperties;
import xyz.tcheeric.gateway.app.config.GatewayBunkerProperties;
import xyz.tcheeric.gateway.app.config.GatewaySecurityApiKeysProperties;
import xyz.tcheeric.gateway.security.audit.AuditLogger;
import xyz.tcheeric.identity.api.ports.BunkerConnectionPort;
import xyz.tcheeric.identity.api.ports.BunkerIdentityRepository;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.api.ports.ProfilePort;
import xyz.tcheeric.identity.api.ports.SigningPort;
import xyz.tcheeric.identity.api.ports.TokenPort;
import xyz.tcheeric.identity.application.usecases.bunker.CreateBunkerIdentityUseCase;
import xyz.tcheeric.identity.application.usecases.bunker.DecryptMessageUseCase;
import xyz.tcheeric.identity.application.usecases.bunker.DeleteBunkerIdentityUseCase;
import xyz.tcheeric.identity.application.usecases.bunker.EncryptMessageUseCase;
import xyz.tcheeric.identity.application.usecases.bunker.ImportIdentityToBunkerUseCase;
import xyz.tcheeric.identity.application.usecases.bunker.SignEventWithBunkerUseCase;
import xyz.tcheeric.identity.application.usecases.policy.CreatePolicyUseCase;
import xyz.tcheeric.identity.application.usecases.policy.DeletePolicyUseCase;
import xyz.tcheeric.identity.application.usecases.policy.ListPoliciesUseCase;
import xyz.tcheeric.identity.application.usecases.policy.UpdatePolicyUseCase;
import xyz.tcheeric.identity.application.usecases.token.CreateAccessTokenUseCase;
import xyz.tcheeric.identity.application.usecases.token.GetTokenStatsUseCase;
import xyz.tcheeric.identity.application.usecases.token.ListAccessTokensUseCase;
import xyz.tcheeric.identity.application.usecases.token.RevokeAccessTokenUseCase;
import xyz.tcheeric.identity.infrastructure.bunker.BunkerConnectionManager;
import xyz.tcheeric.identity.infrastructure.bunker.BunkerIdentityRepositoryAdapter;
import xyz.tcheeric.identity.infrastructure.bunker.BunkerPolicyAdapter;
import xyz.tcheeric.identity.infrastructure.bunker.BunkerSigningAdapter;
import xyz.tcheeric.identity.infrastructure.bunker.BunkerTokenAdapter;
import xyz.tcheeric.identity.infrastructure.nostr.NostrProfileAdapter;

@Configuration
@EnableConfigurationProperties(value={GatewayBunkerProperties.class, GatewayApiKeyProperties.class, GatewaySecurityApiKeysProperties.class})
public class GatewayAppConfiguration {
    @Bean
    @ConditionalOnProperty(name={"gateway.bunker.mock"}, havingValue="false", matchIfMissing=true)
    BunkerConnectionManager bunkerConnectionPort(GatewayBunkerProperties properties) {
        BunkerConnectionManager manager = new BunkerConnectionManager(properties.getBunkerPubkey(), properties.getAdminPrivateKey(), properties.getRelays());
        manager.setConnectionTimeout(properties.getConnectTimeout());
        manager.setRequestTimeout(properties.getRequestTimeout());
        return manager;
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.bunker.mock"}, havingValue="false", matchIfMissing=true)
    BunkerIdentityRepository bunkerIdentityRepository(BunkerConnectionPort connectionPort) {
        return new BunkerIdentityRepositoryAdapter(connectionPort);
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.bunker.mock"}, havingValue="false", matchIfMissing=true)
    PolicyPort policyPort(BunkerConnectionManager connectionManager) {
        return new BunkerPolicyAdapter(() -> {
            try {
                if (!connectionManager.isConnected()) {
                    connectionManager.connect().join();
                }
                return connectionManager.getAdminClient().orElse(null);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.bunker.mock"}, havingValue="false", matchIfMissing=true)
    TokenPort tokenPort(BunkerConnectionManager connectionManager) {
        return new BunkerTokenAdapter(() -> {
            try {
                if (!connectionManager.isConnected()) {
                    connectionManager.connect().join();
                }
                return connectionManager.getAdminClient().orElse(null);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.bunker.mock"}, havingValue="false", matchIfMissing=true)
    SigningPort signingPort(GatewayBunkerProperties properties) {
        return new BunkerSigningAdapter(properties.getClientPrivateKey(), properties.getSignerConnectTimeout(), properties.getSignerRequestTimeout());
    }

    @Bean
    PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    AuditLogger auditLogger() {
        return new AuditLogger();
    }

    @Bean
    ProfilePort profilePort(GatewayBunkerProperties properties, SigningPort signingPort, BunkerIdentityRepository identityRepository) {
        return new NostrProfileAdapter(properties.getRelays(), signingPort, () -> ((List)identityRepository.findAll().join()).stream().findFirst());
    }

    @Bean
    CreateBunkerIdentityUseCase createBunkerIdentityUseCase(BunkerConnectionPort connectionPort, BunkerIdentityRepository identityRepository) {
        return new CreateBunkerIdentityUseCase(connectionPort, identityRepository);
    }

    @Bean
    ImportIdentityToBunkerUseCase importIdentityToBunkerUseCase(BunkerConnectionPort connectionPort, BunkerIdentityRepository identityRepository) {
        return new ImportIdentityToBunkerUseCase(connectionPort, identityRepository);
    }

    @Bean
    DeleteBunkerIdentityUseCase deleteBunkerIdentityUseCase(BunkerConnectionPort connectionPort, BunkerIdentityRepository identityRepository) {
        return new DeleteBunkerIdentityUseCase(connectionPort, identityRepository);
    }

    @Bean
    CreatePolicyUseCase createPolicyUseCase(PolicyPort policyPort) {
        return new CreatePolicyUseCase(policyPort);
    }

    @Bean
    UpdatePolicyUseCase updatePolicyUseCase(PolicyPort policyPort) {
        return new UpdatePolicyUseCase(policyPort);
    }

    @Bean
    DeletePolicyUseCase deletePolicyUseCase(PolicyPort policyPort) {
        return new DeletePolicyUseCase(policyPort);
    }

    @Bean
    ListPoliciesUseCase listPoliciesUseCase(PolicyPort policyPort) {
        return new ListPoliciesUseCase(policyPort);
    }

    @Bean
    CreateAccessTokenUseCase createAccessTokenUseCase(TokenPort tokenPort, BunkerConnectionPort connectionPort, PolicyPort policyPort) {
        return new CreateAccessTokenUseCase(tokenPort, connectionPort, policyPort);
    }

    @Bean
    ListAccessTokensUseCase listAccessTokensUseCase(TokenPort tokenPort) {
        return new ListAccessTokensUseCase(tokenPort);
    }

    @Bean
    RevokeAccessTokenUseCase revokeAccessTokenUseCase(TokenPort tokenPort) {
        return new RevokeAccessTokenUseCase(tokenPort);
    }

    @Bean
    GetTokenStatsUseCase getTokenStatsUseCase(TokenPort tokenPort) {
        return new GetTokenStatsUseCase(tokenPort);
    }

    @Bean
    SignEventWithBunkerUseCase signEventWithBunkerUseCase(SigningPort signingPort, BunkerIdentityRepository identityRepository) {
        return new SignEventWithBunkerUseCase(signingPort, identityRepository);
    }

    @Bean
    EncryptMessageUseCase encryptMessageUseCase(SigningPort signingPort, BunkerIdentityRepository identityRepository) {
        return new EncryptMessageUseCase(signingPort, identityRepository);
    }

    @Bean
    DecryptMessageUseCase decryptMessageUseCase(SigningPort signingPort, BunkerIdentityRepository identityRepository) {
        return new DecryptMessageUseCase(signingPort, identityRepository);
    }
}

