/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import xyz.tcheeric.gateway.app.config.GatewayBunkerProperties;
import xyz.tcheeric.gateway.app.inmemory.InMemoryBunkerConnectionPort;
import xyz.tcheeric.gateway.app.inmemory.InMemoryBunkerIdentityRepository;
import xyz.tcheeric.gateway.app.inmemory.InMemoryGatewayStore;
import xyz.tcheeric.gateway.app.inmemory.InMemoryPolicyPort;
import xyz.tcheeric.gateway.app.inmemory.InMemorySigningPort;
import xyz.tcheeric.gateway.app.inmemory.InMemoryTokenPort;
import xyz.tcheeric.identity.api.ports.BunkerConnectionPort;
import xyz.tcheeric.identity.api.ports.BunkerIdentityRepository;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.api.ports.SigningPort;
import xyz.tcheeric.identity.api.ports.TokenPort;

@Configuration
@ConditionalOnProperty(name={"gateway.bunker.mock"}, havingValue="true")
public class InMemoryGatewayConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryGatewayConfiguration.class);

    @Bean
    InMemoryGatewayStore inMemoryGatewayStore() {
        LOGGER.info("inmemory_gateway_config_activated creating_in_memory_store");
        return new InMemoryGatewayStore();
    }

    @Bean
    @Primary
    BunkerConnectionPort inMemoryBunkerConnectionPort(InMemoryGatewayStore store, GatewayBunkerProperties properties) {
        LOGGER.info("inmemory_bunker_connection creating relays={}", (Object)properties.getRelays().size());
        return new InMemoryBunkerConnectionPort(store, properties.getRelays());
    }

    @Bean
    @Primary
    BunkerIdentityRepository inMemoryBunkerIdentityRepository(InMemoryGatewayStore store) {
        LOGGER.info("inmemory_identity_repository creating");
        return new InMemoryBunkerIdentityRepository(store);
    }

    @Bean
    @Primary
    PolicyPort inMemoryPolicyPort(InMemoryGatewayStore store) {
        LOGGER.info("inmemory_policy_port creating");
        return new InMemoryPolicyPort(store);
    }

    @Bean
    @Primary
    TokenPort inMemoryTokenPort(InMemoryGatewayStore store, GatewayBunkerProperties properties) {
        LOGGER.info("inmemory_token_port creating");
        String defaultRelay = properties.getRelays().isEmpty() ? "wss://relay.nsec.app" : (String)properties.getRelays().get(0);
        return new InMemoryTokenPort(store, defaultRelay);
    }

    @Bean
    @Primary
    SigningPort inMemorySigningPort() {
        LOGGER.info("inmemory_signing_port creating");
        return new InMemorySigningPort();
    }
}

