/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.VoucherBackupService;
import xyz.tcheeric.wallet.core.exception.VoucherBackupException;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

public class LocalVoucherBackupService
implements VoucherBackupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalVoucherBackupService.class);
    private static final TypeReference<List<StoredVoucher>> VOUCHER_LIST_TYPE = new /* Unavailable Anonymous Inner Class!! */;
    private final ObjectMapper objectMapper;
    private final Map<String, List<String>> backupsByOwner = new ConcurrentHashMap();

    public LocalVoucherBackupService() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        LOGGER.info("voucher_backup_service local_storage_mode reason=nostr_not_configured");
    }

    public String serializeVouchers(List<StoredVoucher> vouchers) {
        try {
            String json = this.objectMapper.writeValueAsString(vouchers);
            LOGGER.debug("voucher_backup serialized voucher_count={} json_length={}", (Object)vouchers.size(), (Object)json.length());
            return json;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("voucher_backup serialization_failed voucher_count={} error={}", new Object[]{vouchers.size(), e.getMessage(), e});
            throw new RuntimeException("Failed to serialize vouchers: " + e.getMessage(), e);
        }
    }

    public List<StoredVoucher> deserializeVouchers(String json) throws WalletOperationException {
        try {
            List vouchers = (List)this.objectMapper.readValue(json, VOUCHER_LIST_TYPE);
            LOGGER.debug("voucher_backup deserialized voucher_count={} json_length={}", (Object)vouchers.size(), (Object)json.length());
            return vouchers;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("voucher_backup deserialization_failed json_length={} error={}", new Object[]{json.length(), e.getMessage(), e});
            throw VoucherBackupException.forDeserializationFailure((Throwable)e);
        }
    }

    public String encryptBackup(String voucherJson, String senderPrivateKeyHex, String recipientPublicKeyHex) throws WalletOperationException {
        LOGGER.debug("voucher_backup local_encode json_length={}", (Object)voucherJson.length());
        return Base64.getEncoder().encodeToString(voucherJson.getBytes());
    }

    public String decryptBackup(String encryptedPayload, String selfPrivateKeyHex, String otherPublicKeyHex) throws WalletOperationException {
        LOGGER.debug("voucher_backup local_decode payload_length={}", (Object)encryptedPayload.length());
        try {
            return new String(Base64.getDecoder().decode(encryptedPayload));
        }
        catch (IllegalArgumentException e) {
            throw VoucherBackupException.forDecryptionFailure((Throwable)e);
        }
    }

    public String publishBackup(String encryptedPayload, String ownerPublicKeyHex) throws WalletOperationException {
        String eventId = "local-" + UUID.randomUUID().toString().substring(0, 8);
        this.backupsByOwner.computeIfAbsent(ownerPublicKeyHex, k -> new ArrayList()).add(0, encryptedPayload);
        LOGGER.info("voucher_backup published_locally event_id={} owner_pubkey={} payload_length={}", new Object[]{eventId, ownerPublicKeyHex.substring(0, 8) + "...", encryptedPayload.length()});
        return eventId;
    }

    public List<String> queryBackups(String ownerPublicKeyHex, int limit) throws WalletOperationException {
        List backups = this.backupsByOwner.getOrDefault(ownerPublicKeyHex, List.of());
        List<String> result = backups.stream().limit(limit).toList();
        LOGGER.info("voucher_backup queried_locally owner_pubkey={} found={} limit={}", new Object[]{ownerPublicKeyHex.substring(0, 8) + "...", result.size(), limit});
        return result;
    }
}

