/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import xyz.tcheeric.gateway.api.port.NutzapPort;
import xyz.tcheeric.gateway.api.port.WalletPort;
import xyz.tcheeric.gateway.api.port.WalletSyncPort;
import xyz.tcheeric.gateway.app.config.GatewayWalletProperties;
import xyz.tcheeric.gateway.app.config.StubWalletConfiguration;

@Configuration
@EnableConfigurationProperties(value={GatewayWalletProperties.class})
public class StubWalletConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(StubWalletConfiguration.class);

    @Bean
    @ConditionalOnProperty(name={"gateway.wallet.enabled"}, havingValue="false", matchIfMissing=true)
    WalletPort stubWalletPort(GatewayWalletProperties properties) {
        GatewayWalletProperties.Voucher voucherConfig = properties.getVoucher();
        LOGGER.info("wallet_stub_enabled reason=no_other_wallet_port_bean_exists fixed_backing_sats={} minimal_backing_sats={} sats_per_minor_unit={} platform_fee_rate={}", new Object[]{voucherConfig.getFixedBackingSats(), voucherConfig.getMinimalBackingSats(), voucherConfig.getSatsPerMinorUnit(), voucherConfig.getPlatformFeeRate()});
        return new StubWalletPort(voucherConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={NutzapPort.class})
    NutzapPort stubNutzapPort() {
        LOGGER.info("nutzap_stub_enabled reason=no_nutzap_port_bean_available");
        return new StubNutzapPort();
    }

    @Bean
    @ConditionalOnMissingBean(value={WalletSyncPort.class})
    WalletSyncPort stubWalletSyncPort() {
        LOGGER.info("wallet_sync_stub_enabled reason=no_wallet_sync_port_bean_available");
        return new StubWalletSyncPort();
    }
}

