/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import java.util.List;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import xyz.tcheeric.gateway.app.config.GatewayWalletProperties;
import xyz.tcheeric.wallet.core.VoucherService;

@Component
@ConditionalOnClass(name={"xyz.tcheeric.wallet.core.VoucherService"})
@ConditionalOnProperty(name={"gateway.wallet.enabled"}, havingValue="true")
public class VoucherHealthIndicator
implements HealthIndicator {
    private final VoucherService voucherService;
    private final GatewayWalletProperties properties;

    public VoucherHealthIndicator(VoucherService voucherService, GatewayWalletProperties properties) {
        this.voucherService = voucherService;
        this.properties = properties;
    }

    public Health health() {
        try {
            List vouchers = this.voucherService.listVouchers();
            int voucherCount = vouchers != null ? vouchers.size() : 0;
            GatewayWalletProperties.Voucher voucherConfig = this.properties.getVoucher();
            return Health.up().withDetail("status", (Object)"available").withDetail("voucherCount", (Object)voucherCount).withDetail("discountRate", (Object)voucherConfig.getDiscountRate()).withDetail("platformFee", (Object)voucherConfig.getPlatformFee()).withDetail("autopay", (Object)voucherConfig.isAutopay()).withDetail("backupType", (Object)"local").build();
        }
        catch (IllegalStateException e) {
            return Health.up().withDetail("status", (Object)"initialization_pending").withDetail("message", (Object)"VoucherService will initialize on first wallet operation").build();
        }
        catch (Exception e) {
            return Health.down().withDetail("status", (Object)"error").withDetail("error", (Object)e.getMessage()).build();
        }
    }
}

