/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.inmemory;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import xyz.tcheeric.gateway.app.inmemory.InMemoryGatewayStore;
import xyz.tcheeric.identity.api.ports.BunkerConnectionPort;
import xyz.tcheeric.identity.domain.BunkerIdentity;
import xyz.tcheeric.identity.domain.PublicKey;

public class InMemoryBunkerConnectionPort
implements BunkerConnectionPort {
    private static final List<String> DEFAULT_RELAYS = List.of("wss://relay.nsec.app");
    private final InMemoryGatewayStore store;
    private final List<String> relays;
    private BunkerConnectionPort.ConnectionState state = BunkerConnectionPort.ConnectionState.DISCONNECTED;
    private Duration connectTimeout = Duration.ofSeconds(5L);
    private Duration requestTimeout = Duration.ofSeconds(5L);

    public InMemoryBunkerConnectionPort(InMemoryGatewayStore store) {
        this(store, DEFAULT_RELAYS);
    }

    public InMemoryBunkerConnectionPort(InMemoryGatewayStore store, List<String> relays) {
        this.store = store;
        this.relays = relays != null && !relays.isEmpty() ? List.copyOf(relays) : DEFAULT_RELAYS;
    }

    public CompletableFuture<Void> connect() {
        this.state = BunkerConnectionPort.ConnectionState.CONNECTED;
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> disconnect() {
        this.state = BunkerConnectionPort.ConnectionState.DISCONNECTED;
        return CompletableFuture.completedFuture(null);
    }

    public boolean isConnected() {
        return this.state == BunkerConnectionPort.ConnectionState.CONNECTED;
    }

    public BunkerConnectionPort.ConnectionState getConnectionState() {
        return this.state;
    }

    public CompletableFuture<String> ping() {
        return CompletableFuture.completedFuture("pong");
    }

    public CompletableFuture<BunkerConnectionPort.HealthStatus> healthCheck() {
        return CompletableFuture.completedFuture(BunkerConnectionPort.HealthStatus.healthy((long)1L, (int)this.store.identitiesById().size()));
    }

    public CompletableFuture<BunkerIdentity> createKey(String keyName, String passphrase) {
        String pubkeyHex = this.store.generatePublicKeyHex();
        BunkerIdentity identity = new BunkerIdentity(UUID.randomUUID().toString(), keyName, this.store.toPublicKey(pubkeyHex), this.relays, false, null, null, Instant.now(), null);
        this.store.identitiesById().put(identity.getId(), identity);
        this.store.identitiesByKey().put(identity.getKeyName(), identity);
        return CompletableFuture.completedFuture(identity);
    }

    public CompletableFuture<BunkerIdentity> importKey(String keyName, String nsec, String passphrase) {
        return this.createKey(keyName, passphrase);
    }

    public CompletableFuture<List<BunkerIdentity>> listKeys() {
        return CompletableFuture.completedFuture(List.copyOf(this.store.identitiesById().values()));
    }

    public CompletableFuture<Optional<BunkerIdentity>> getKey(String keyName) {
        return CompletableFuture.completedFuture(Optional.ofNullable((BunkerIdentity)this.store.identitiesByKey().get(keyName)));
    }

    public CompletableFuture<Optional<BunkerIdentity>> findKeyByPublicKey(PublicKey publicKey) {
        return CompletableFuture.completedFuture(this.store.identitiesById().values().stream().filter(id -> id.getPublicKey().equals((Object)publicKey)).findFirst());
    }

    public CompletableFuture<Boolean> unlockKey(String keyName, String passphrase) {
        BunkerIdentity identity = (BunkerIdentity)this.store.identitiesByKey().get(keyName);
        if (identity == null) {
            return CompletableFuture.completedFuture(false);
        }
        this.store.identitiesByKey().put(keyName, identity.withLocked(false));
        this.store.identitiesById().put(identity.getId(), identity.withLocked(false));
        return CompletableFuture.completedFuture(true);
    }

    public CompletableFuture<Boolean> deleteKey(String keyName) {
        BunkerIdentity removed = (BunkerIdentity)this.store.identitiesByKey().remove(keyName);
        if (removed != null) {
            this.store.identitiesById().remove(removed.getId());
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.completedFuture(false);
    }

    public String getBunkerPubkey() {
        return "stub-bunker-pubkey";
    }

    public List<String> getRelays() {
        return this.relays;
    }

    public void setConnectionTimeout(Duration timeout) {
        this.connectTimeout = timeout;
    }

    public void setRequestTimeout(Duration timeout) {
        this.requestTimeout = timeout;
    }
}

