/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.inmemory;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import xyz.tcheeric.gateway.app.inmemory.InMemoryGatewayStore;
import xyz.tcheeric.identity.api.ports.BunkerIdentityRepository;
import xyz.tcheeric.identity.domain.BunkerIdentity;
import xyz.tcheeric.identity.domain.PublicKey;

public class InMemoryBunkerIdentityRepository
implements BunkerIdentityRepository {
    private final InMemoryGatewayStore store;

    public InMemoryBunkerIdentityRepository(InMemoryGatewayStore store) {
        this.store = store;
    }

    public CompletableFuture<Optional<BunkerIdentity>> findById(String id) {
        return CompletableFuture.completedFuture(Optional.ofNullable((BunkerIdentity)this.store.identitiesById().get(id)));
    }

    public CompletableFuture<Optional<BunkerIdentity>> findByKeyName(String keyName) {
        return CompletableFuture.completedFuture(Optional.ofNullable((BunkerIdentity)this.store.identitiesByKey().get(keyName)));
    }

    public CompletableFuture<Optional<BunkerIdentity>> findByPublicKey(PublicKey publicKey) {
        return CompletableFuture.completedFuture(this.store.identitiesById().values().stream().filter(identity -> identity.getPublicKey().equals((Object)publicKey)).findFirst());
    }

    public CompletableFuture<List<BunkerIdentity>> findAll() {
        return CompletableFuture.completedFuture(List.copyOf(this.store.identitiesById().values()));
    }

    public CompletableFuture<Void> save(BunkerIdentity identity) {
        this.store.identitiesById().put(identity.getId(), identity);
        this.store.identitiesByKey().put(identity.getKeyName(), identity);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> delete(String id) {
        BunkerIdentity identity = (BunkerIdentity)this.store.identitiesById().remove(id);
        if (identity != null) {
            this.store.identitiesByKey().remove(identity.getKeyName());
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> deleteByKeyName(String keyName) {
        BunkerIdentity identity = (BunkerIdentity)this.store.identitiesByKey().remove(keyName);
        if (identity != null) {
            this.store.identitiesById().remove(identity.getId());
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Boolean> exists(String id) {
        return CompletableFuture.completedFuture(this.store.identitiesById().containsKey(id));
    }

    public CompletableFuture<Boolean> existsByKeyName(String keyName) {
        return CompletableFuture.completedFuture(this.store.identitiesByKey().containsKey(keyName));
    }

    public CompletableFuture<Long> count() {
        return CompletableFuture.completedFuture(Long.valueOf(this.store.identitiesById().size()));
    }

    public CompletableFuture<Integer> syncWithBunker() {
        return CompletableFuture.completedFuture(this.store.identitiesById().size());
    }
}

