/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.inmemory;

import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import xyz.tcheeric.identity.domain.AccessToken;
import xyz.tcheeric.identity.domain.BunkerIdentity;
import xyz.tcheeric.identity.domain.PublicKey;
import xyz.tcheeric.identity.domain.SigningPolicy;

public class InMemoryGatewayStore {
    private final Map<String, BunkerIdentity> identitiesById = new ConcurrentHashMap();
    private final Map<String, BunkerIdentity> identitiesByKey = new ConcurrentHashMap();
    private final Map<String, SigningPolicy> policiesById = new ConcurrentHashMap();
    private final Map<String, Set<String>> policyBindings = new ConcurrentHashMap();
    private final Map<String, AccessToken> tokensById = new ConcurrentHashMap();

    public Map<String, BunkerIdentity> identitiesById() {
        return this.identitiesById;
    }

    public Map<String, BunkerIdentity> identitiesByKey() {
        return this.identitiesByKey;
    }

    public Map<String, SigningPolicy> policiesById() {
        return this.policiesById;
    }

    public Map<String, Set<String>> policyBindings() {
        return this.policyBindings;
    }

    public Map<String, AccessToken> tokensById() {
        return this.tokensById;
    }

    public String generatePublicKeyHex() {
        byte[] bytes = new byte[32];
        new SecureRandom().nextBytes(bytes);
        return this.bytesToHex(bytes);
    }

    public PublicKey toPublicKey(String hex) {
        return PublicKey.fromHex((String)hex);
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public Optional<String> findPolicyName(String policyId) {
        return Optional.ofNullable((SigningPolicy)this.policiesById.get(policyId)).map(SigningPolicy::getName);
    }
}

