/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.inmemory;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import xyz.tcheeric.gateway.app.inmemory.InMemoryGatewayStore;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.domain.SigningPolicy;

public class InMemoryPolicyPort
implements PolicyPort {
    private final InMemoryGatewayStore store;

    public InMemoryPolicyPort(InMemoryGatewayStore store) {
        this.store = store;
    }

    public CompletableFuture<SigningPolicy> createPolicy(SigningPolicy policy) {
        SigningPolicy toStore = policy.getId() == null ? new SigningPolicy(policy.getName(), (String)policy.getDescription().orElse(null)) : policy;
        this.store.policiesById().put(toStore.getId(), toStore);
        return CompletableFuture.completedFuture(toStore);
    }

    public CompletableFuture<Optional<SigningPolicy>> getPolicy(String policyId) {
        return CompletableFuture.completedFuture(Optional.ofNullable((SigningPolicy)this.store.policiesById().get(policyId)));
    }

    public CompletableFuture<List<SigningPolicy>> listPolicies() {
        return CompletableFuture.completedFuture(List.copyOf(this.store.policiesById().values()));
    }

    public CompletableFuture<SigningPolicy> updatePolicy(SigningPolicy policy) {
        this.store.policiesById().put(policy.getId(), policy);
        return CompletableFuture.completedFuture(policy);
    }

    public CompletableFuture<Boolean> deletePolicy(String policyId) {
        SigningPolicy removed = (SigningPolicy)this.store.policiesById().remove(policyId);
        this.store.policyBindings().values().forEach(set -> set.remove(policyId));
        return CompletableFuture.completedFuture(removed != null);
    }

    public CompletableFuture<Void> attachPolicyToKey(String policyId, String keyName) {
        this.store.policyBindings().computeIfAbsent(keyName, k -> Collections.newSetFromMap(new ConcurrentHashMap())).add(policyId);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> detachPolicyFromKey(String policyId, String keyName) {
        this.store.policyBindings().computeIfAbsent(keyName, k -> Collections.newSetFromMap(new ConcurrentHashMap())).remove(policyId);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<SigningPolicy>> listPoliciesForKey(String keyName) {
        Set policyIds = this.store.policyBindings().getOrDefault(keyName, Set.of());
        List<SigningPolicy> result = policyIds.stream().map(this.store.policiesById()::get).filter(Objects::nonNull).toList();
        return CompletableFuture.completedFuture(result);
    }
}

