/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.inmemory;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import xyz.tcheeric.identity.api.ports.SigningPort;
import xyz.tcheeric.identity.domain.BunkerIdentity;
import xyz.tcheeric.identity.domain.NostrEvent;

public class InMemorySigningPort
implements SigningPort {
    public CompletableFuture<SigningPort.SignedEventResult> signEvent(BunkerIdentity identity, NostrEvent event) {
        return CompletableFuture.supplyAsync(() -> {
            String eventId = this.hash(event.pubkey() + ":" + event.content());
            String signature = "sig-" + this.hash(identity.getPublicKey().toHex() + ":" + eventId).substring(0, 16);
            return new SigningPort.SignedEventResult(eventId, signature);
        });
    }

    public CompletableFuture<String> nip04Encrypt(BunkerIdentity identity, String recipientPubkey, String plaintext) {
        return CompletableFuture.completedFuture(Base64.getEncoder().encodeToString(plaintext.getBytes(StandardCharsets.UTF_8)));
    }

    public CompletableFuture<String> nip04Decrypt(BunkerIdentity identity, String senderPubkey, String ciphertext) {
        return CompletableFuture.completedFuture(new String(Base64.getDecoder().decode(ciphertext), StandardCharsets.UTF_8));
    }

    public CompletableFuture<String> nip44Encrypt(BunkerIdentity identity, String recipientPubkey, String plaintext) {
        return this.nip04Encrypt(identity, recipientPubkey, plaintext);
    }

    public CompletableFuture<String> nip44Decrypt(BunkerIdentity identity, String senderPubkey, String ciphertext) {
        return this.nip04Decrypt(identity, senderPubkey, ciphertext);
    }

    public CompletableFuture<String> getPublicKey(BunkerIdentity identity) {
        return CompletableFuture.completedFuture(identity.getPublicKey().toHex());
    }

    public CompletableFuture<String> ping(BunkerIdentity identity) {
        return CompletableFuture.completedFuture("pong");
    }

    private String hash(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashed = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : hashed) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 not available", e);
        }
    }
}

