/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.security;

import java.util.Collection;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import xyz.tcheeric.gateway.rest.user.User;

public class GatewayUserDetails
implements UserDetails {
    private final User user;
    private final Collection<? extends GrantedAuthority> authorities;

    public GatewayUserDetails(User user) {
        this.user = user;
        this.authorities = List.of(new SimpleGrantedAuthority("ROLE_USER"));
    }

    public String getClientId() {
        return this.user.getClientId();
    }

    public String getDisplayName() {
        return this.user.getDisplayName() != null ? this.user.getDisplayName() : this.user.getEmail();
    }

    public User getUser() {
        return this.user;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.user.getPasswordHash();
    }

    public String getUsername() {
        return this.user.getEmail();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }
}

