/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import xyz.tcheeric.gateway.app.security.GatewayUserDetails;
import xyz.tcheeric.gateway.app.service.UserService;
import xyz.tcheeric.gateway.rest.user.User;

public class GatewayUserDetailsService
implements UserDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayUserDetailsService.class);
    private final UserService userService;

    public GatewayUserDetailsService(UserService userService) {
        this.userService = userService;
    }

    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        LOGGER.debug("user_details_service load_user email={}", (Object)email);
        User user = (User)this.userService.findByEmail(email).orElseThrow(() -> {
            LOGGER.debug("user_details_service user_not_found email={}", (Object)email);
            return new UsernameNotFoundException("User not found: " + email);
        });
        if (!user.isEnabled()) {
            LOGGER.debug("user_details_service user_disabled email={}", (Object)email);
            throw new UsernameNotFoundException("User account is disabled: " + email);
        }
        LOGGER.debug("user_details_service load_user_success email={} client_id={}", (Object)email, (Object)user.getClientId());
        return new GatewayUserDetails(user);
    }
}

