/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.security;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import xyz.tcheeric.gateway.app.security.ConfigurableApiKeyStore;
import xyz.tcheeric.gateway.app.security.SecureApiKeyStore;
import xyz.tcheeric.gateway.security.auth.ApiKeyAuthentication;
import xyz.tcheeric.gateway.security.auth.ApiKeyStore;

public class SecureApiKeyStore
implements ConfigurableApiKeyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureApiKeyStore.class);
    private static final String ENCRYPTION_ALGO = "AES/GCM/NoPadding";
    private static final int IV_LENGTH = 12;
    private static final int TAG_LENGTH = 128;
    private final Map<String, KeyRecord> keysById = new ConcurrentHashMap();
    private final Map<String, String> clientToKeyId = new ConcurrentHashMap();
    private final SecureRandom secureRandom = new SecureRandom();
    private final PasswordEncoder passwordEncoder;
    private final SecretKeySpec encryptionKey;

    public SecureApiKeyStore(String masterKey, PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
        this.encryptionKey = new SecretKeySpec(this.deriveKey(masterKey), "AES");
    }

    public Optional<ApiKeyAuthentication> validate(String apiKey) {
        return this.keysById.values().stream().filter(record -> !record.revoked()).filter(record -> this.passwordEncoder.matches((CharSequence)apiKey, record.secretHash())).findFirst().map(record -> new ApiKeyAuthentication(record.clientId(), record.apiKeyId(), record.permissions(), record.rateLimit()));
    }

    public ApiKeyStore.ApiKeyCreationResult create(String clientId, Set<String> permissions, ApiKeyAuthentication.RateLimitConfig rateLimit) {
        String apiKeyId = "key_" + Math.abs(this.secureRandom.nextInt());
        String apiKey = this.generateKey();
        String hashed = this.passwordEncoder.encode((CharSequence)apiKey);
        String encrypted = this.encrypt(apiKey);
        KeyRecord record = new KeyRecord(apiKeyId, clientId, permissions, rateLimit, hashed, encrypted, false);
        this.keysById.put(apiKeyId, record);
        this.clientToKeyId.put(clientId, apiKeyId);
        return new ApiKeyStore.ApiKeyCreationResult(apiKeyId, apiKey, clientId);
    }

    public boolean revoke(String apiKeyId) {
        KeyRecord record = (KeyRecord)this.keysById.get(apiKeyId);
        if (record == null) {
            return false;
        }
        this.keysById.put(apiKeyId, record.withRevoked(true));
        return true;
    }

    public void registerKey(String clientId, String apiKey, String apiSecret, Set<String> scopes, int rateLimit) {
        String apiKeyId = "key_" + clientId;
        String hashed = this.passwordEncoder.encode((CharSequence)apiKey);
        String encrypted = apiSecret != null ? this.encrypt(apiSecret) : null;
        ApiKeyAuthentication.RateLimitConfig rateLimitConfig = new ApiKeyAuthentication.RateLimitConfig(rateLimit, 60);
        KeyRecord record = new KeyRecord(apiKeyId, clientId, scopes, rateLimitConfig, hashed, encrypted, false);
        this.keysById.put(apiKeyId, record);
        this.clientToKeyId.put(clientId, apiKeyId);
        LOGGER.info("api_key_registered client_id={} api_key_id={} scopes={}", new Object[]{clientId, apiKeyId, scopes.size()});
    }

    public Optional<String> findSecretByClientId(String clientId) {
        String keyId = (String)this.clientToKeyId.get(clientId);
        if (keyId == null) {
            return Optional.empty();
        }
        KeyRecord record = (KeyRecord)this.keysById.get(keyId);
        if (record == null || record.revoked()) {
            return Optional.empty();
        }
        return Optional.of(this.decrypt(record.encryptedSecret()));
    }

    private String generateKey() {
        byte[] bytes = new byte[32];
        this.secureRandom.nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    private byte[] deriveKey(String masterKey) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(masterKey.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to derive encryption key", e);
        }
    }

    private String encrypt(String secret) {
        try {
            byte[] iv = new byte[12];
            this.secureRandom.nextBytes(iv);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGO);
            cipher.init(1, (Key)this.encryptionKey, new GCMParameterSpec(128, iv));
            byte[] cipherText = cipher.doFinal(secret.getBytes(StandardCharsets.UTF_8));
            ByteBuffer buffer = ByteBuffer.allocate(iv.length + cipherText.length);
            buffer.put(iv);
            buffer.put(cipherText);
            return Base64.getEncoder().encodeToString(buffer.array());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encrypt API key", e);
        }
    }

    private String decrypt(String encoded) {
        try {
            byte[] data = Base64.getDecoder().decode(encoded);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            byte[] iv = new byte[12];
            buffer.get(iv);
            byte[] cipherText = new byte[buffer.remaining()];
            buffer.get(cipherText);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGO);
            cipher.init(2, (Key)this.encryptionKey, new GCMParameterSpec(128, iv));
            byte[] plain = cipher.doFinal(cipherText);
            return new String(plain, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decrypt API key", e);
        }
    }
}

