/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.service;

import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import xyz.tcheeric.gateway.app.service.UserService;
import xyz.tcheeric.gateway.rest.user.User;
import xyz.tcheeric.gateway.rest.user.UserRepository;

public class UserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserService.class);
    private static final String CLIENT_ID_PREFIX = "usr_";
    private final UserRepository userRepository;
    private final PasswordEncoder passwordEncoder;

    public UserService(UserRepository userRepository, PasswordEncoder passwordEncoder) {
        this.userRepository = userRepository;
        this.passwordEncoder = passwordEncoder;
        LOGGER.info("user_service initialized");
    }

    public RegistrationResult register(String email, String password, String displayName) {
        LOGGER.debug("user_service register_attempt email={}", (Object)email);
        if (email == null || !email.contains("@") || email.length() > 255) {
            LOGGER.warn("user_service register_invalid_email email={}", (Object)email);
            throw new UserRegistrationException("Invalid email address");
        }
        if (this.userRepository.existsByEmail(email)) {
            LOGGER.warn("user_service register_email_exists email={}", (Object)email);
            throw new UserRegistrationException("Email already registered");
        }
        if (password == null || password.length() < 8) {
            LOGGER.warn("user_service register_weak_password email={}", (Object)email);
            throw new UserRegistrationException("Password must be at least 8 characters");
        }
        String clientId = this.generateClientId();
        String passwordHash = this.passwordEncoder.encode((CharSequence)password);
        User user = new User(email, passwordHash, clientId);
        user.setDisplayName(displayName);
        User saved = this.userRepository.save(user);
        LOGGER.info("user_service register_success email={} client_id={}", (Object)email, (Object)clientId);
        return new RegistrationResult(saved.getId(), saved.getEmail(), saved.getClientId());
    }

    public Optional<User> findByEmail(String email) {
        return this.userRepository.findByEmail(email);
    }

    public Optional<User> findByClientId(String clientId) {
        return this.userRepository.findByClientId(clientId);
    }

    public void recordLogin(String email) {
        this.userRepository.updateLastLogin(email);
        LOGGER.debug("user_service login_recorded email={}", (Object)email);
    }

    public boolean validatePassword(String rawPassword, String passwordHash) {
        return this.passwordEncoder.matches((CharSequence)rawPassword, passwordHash);
    }

    public boolean disableUser(String email) {
        boolean disabled = this.userRepository.disable(email);
        if (disabled) {
            LOGGER.info("user_service user_disabled email={}", (Object)email);
        }
        return disabled;
    }

    private String generateClientId() {
        return CLIENT_ID_PREFIX + UUID.randomUUID().toString().replace("-", "").substring(0, 16);
    }
}

