/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.web;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import xyz.tcheeric.gateway.app.security.GatewayUserDetails;
import xyz.tcheeric.gateway.app.service.UserService;
import xyz.tcheeric.gateway.security.auth.ApiKeyAuthentication;
import xyz.tcheeric.gateway.security.auth.ApiKeyStore;

@Controller
@RequestMapping(value={"/web"})
@ConditionalOnProperty(name={"gateway.web.enabled"}, havingValue="true", matchIfMissing=false)
public class DashboardController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardController.class);
    private final ApiKeyStore apiKeyStore;
    private final UserService userService;

    public DashboardController(ApiKeyStore apiKeyStore, UserService userService) {
        this.apiKeyStore = apiKeyStore;
        this.userService = userService;
    }

    @GetMapping(value={"/dashboard"})
    public String dashboard(@AuthenticationPrincipal GatewayUserDetails userDetails, Model model) {
        String clientId = userDetails.getClientId();
        LOGGER.debug("dashboard_controller dashboard_view client_id={}", (Object)clientId);
        this.userService.recordLogin(userDetails.getUsername());
        List keys = this.apiKeyStore.listByClientId(clientId);
        model.addAttribute("displayName", (Object)userDetails.getDisplayName());
        model.addAttribute("email", (Object)userDetails.getUsername());
        model.addAttribute("clientId", (Object)clientId);
        model.addAttribute("keys", (Object)keys);
        return "dashboard";
    }

    @PostMapping(value={"/keys/create"})
    public String createKey(@AuthenticationPrincipal GatewayUserDetails userDetails, @RequestParam(required=false) String name, @RequestParam(required=false) String description, @RequestParam(required=false) String permissions, @RequestParam(required=false) Integer expirationDays, RedirectAttributes redirectAttributes) {
        String clientId = userDetails.getClientId();
        LOGGER.debug("dashboard_controller create_key_attempt client_id={}", (Object)clientId);
        try {
            Set permissionSet = this.parsePermissions(permissions);
            Instant expiresAt = null;
            if (expirationDays != null && expirationDays > 0) {
                expiresAt = Instant.now().plus((long)expirationDays.intValue(), ChronoUnit.DAYS);
            }
            ApiKeyStore.ApiKeyCreateCommand command = new ApiKeyStore.ApiKeyCreateCommand(clientId, permissionSet, ApiKeyAuthentication.RateLimitConfig.DEFAULT, name, description, expiresAt);
            ApiKeyStore.ApiKeyCreationResult result = this.apiKeyStore.create(command);
            LOGGER.info("dashboard_controller create_key_success client_id={} key_id={}", (Object)clientId, (Object)result.apiKeyId());
            redirectAttributes.addFlashAttribute("newKey", (Object)result.apiKey());
            redirectAttributes.addFlashAttribute("newKeyId", (Object)result.apiKeyId());
            redirectAttributes.addFlashAttribute("message", (Object)"API key created successfully. Copy it now - it won't be shown again!");
        }
        catch (Exception e) {
            LOGGER.error("dashboard_controller create_key_failed client_id={} error={}", new Object[]{clientId, e.getMessage(), e});
            redirectAttributes.addFlashAttribute("error", (Object)("Failed to create API key: " + e.getMessage()));
        }
        return "redirect:/web/dashboard";
    }

    @PostMapping(value={"/keys/{keyId}/revoke"})
    public String revokeKey(@AuthenticationPrincipal GatewayUserDetails userDetails, @PathVariable String keyId, RedirectAttributes redirectAttributes) {
        String clientId = userDetails.getClientId();
        LOGGER.debug("dashboard_controller revoke_key_attempt client_id={} key_id={}", (Object)clientId, (Object)keyId);
        Optional keyInfo = this.apiKeyStore.findById(keyId, clientId);
        if (keyInfo.isEmpty()) {
            redirectAttributes.addFlashAttribute("error", (Object)"API key not found");
            return "redirect:/web/dashboard";
        }
        boolean revoked = this.apiKeyStore.revoke(keyId);
        if (revoked) {
            LOGGER.info("dashboard_controller revoke_key_success client_id={} key_id={}", (Object)clientId, (Object)keyId);
            redirectAttributes.addFlashAttribute("message", (Object)"API key revoked successfully");
        } else {
            redirectAttributes.addFlashAttribute("error", (Object)"Failed to revoke API key");
        }
        return "redirect:/web/dashboard";
    }

    @PostMapping(value={"/keys/{keyId}/rotate"})
    public String rotateKey(@AuthenticationPrincipal GatewayUserDetails userDetails, @PathVariable String keyId, @RequestParam(defaultValue="60") int gracePeriodMinutes, RedirectAttributes redirectAttributes) {
        String clientId = userDetails.getClientId();
        LOGGER.debug("dashboard_controller rotate_key_attempt client_id={} key_id={} grace_period={}", new Object[]{clientId, keyId, gracePeriodMinutes});
        Optional result = this.apiKeyStore.rotate(keyId, clientId, Duration.ofMinutes(gracePeriodMinutes));
        if (result.isPresent()) {
            LOGGER.info("dashboard_controller rotate_key_success client_id={} old_key_id={} new_key_id={}", new Object[]{clientId, keyId, ((ApiKeyStore.ApiKeyCreationResult)result.get()).apiKeyId()});
            redirectAttributes.addFlashAttribute("newKey", (Object)((ApiKeyStore.ApiKeyCreationResult)result.get()).apiKey());
            redirectAttributes.addFlashAttribute("newKeyId", (Object)((ApiKeyStore.ApiKeyCreationResult)result.get()).apiKeyId());
            redirectAttributes.addFlashAttribute("message", (Object)("API key rotated. Old key valid for " + gracePeriodMinutes + " minutes. Copy the new key now!"));
        } else {
            redirectAttributes.addFlashAttribute("error", (Object)"Failed to rotate API key");
        }
        return "redirect:/web/dashboard";
    }

    private Set<String> parsePermissions(String permissions) {
        if (permissions == null || permissions.isBlank()) {
            return Set.of("*");
        }
        return Set.of(permissions.split(","));
    }
}

