-- Users table for web authentication
-- Each user maps 1:1 to a clientId for API key management
CREATE TABLE IF NOT EXISTS users (
    id              BIGINT GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    email           VARCHAR(255) NOT NULL UNIQUE,
    password_hash   VARCHAR(255) NOT NULL,
    client_id       VARCHAR(128) NOT NULL UNIQUE,
    display_name    VARCHAR(128),
    enabled         BOOLEAN NOT NULL DEFAULT TRUE,
    created_at      TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,
    last_login_at   TIMESTAMP WITH TIME ZONE,

    -- Foreign key to ensure client_id integrity (optional, for audit)
    CONSTRAINT fk_users_client_id_check CHECK (client_id ~ '^usr_[a-zA-Z0-9]+$')
);

-- Index for login lookups
CREATE INDEX idx_users_email ON users(email);

-- Index for API key operations (finding user by clientId)
CREATE INDEX idx_users_client_id ON users(client_id);

-- Index for listing enabled users
CREATE INDEX idx_users_enabled ON users(enabled) WHERE enabled = TRUE;
