/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import xyz.tcheeric.gateway.app.persistence.PostgresApiKeyStore;
import xyz.tcheeric.gateway.app.security.SecureApiKeyStore;
import xyz.tcheeric.gateway.security.auth.ApiKeyStore;
import xyz.tcheeric.gateway.security.auth.HmacSignatureValidator;
import xyz.tcheeric.gateway.security.auth.PermissionEvaluator;
import xyz.tcheeric.gateway.security.filter.ApiKeyAuthFilter;
import xyz.tcheeric.gateway.security.filter.HmacSignatureFilter;
import xyz.tcheeric.gateway.security.filter.Nip98AuthFilter;
import xyz.tcheeric.gateway.security.filter.RateLimitFilter;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class GatewaySecurityConfiguration {
    @Bean
    public ApiKeyAuthFilter apiKeyAuthFilter(ApiKeyStore apiKeyStore, ObjectMapper objectMapper) {
        return new ApiKeyAuthFilter(apiKeyStore, objectMapper);
    }

    @Bean
    public RateLimitFilter rateLimitFilter(ObjectMapper objectMapper) {
        return new RateLimitFilter(objectMapper);
    }

    @Bean
    public Nip98AuthFilter nip98AuthFilter(ObjectMapper objectMapper, @Value(value="${gateway.security.nip98.enabled:true}") boolean nip98Enabled) {
        Set<Object> protectedPaths = nip98Enabled ? Set.of("/api/v1/profiles") : Set.of();
        return new Nip98AuthFilter(objectMapper, protectedPaths);
    }

    @Bean
    public HmacSignatureFilter hmacSignatureFilter(HmacSignatureValidator validator, ObjectMapper objectMapper) {
        return new HmacSignatureFilter(validator, objectMapper);
    }

    @Bean
    public PermissionEvaluator permissionEvaluator() {
        return new PermissionEvaluator();
    }

    @Bean
    public HmacSignatureValidator.SecretKeyProvider hmacSecretKeyProvider(ApiKeyStore apiKeyStore) {
        if (apiKeyStore instanceof PostgresApiKeyStore) {
            PostgresApiKeyStore postgresStore = (PostgresApiKeyStore)apiKeyStore;
            return postgresStore::findSecretByClientId;
        }
        if (apiKeyStore instanceof SecureApiKeyStore) {
            SecureApiKeyStore secureStore = (SecureApiKeyStore)apiKeyStore;
            return secureStore::findSecretByClientId;
        }
        return clientId -> Optional.empty();
    }

    @Bean
    public HmacSignatureValidator hmacSignatureValidator(HmacSignatureValidator.SecretKeyProvider provider) {
        return new HmacSignatureValidator(provider);
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOriginPatterns(List.of("https://dev.398ja.xyz", "https://imani.casa", "https://*.imani.casa", "http://localhost:9545", "http://localhost:3000"));
        configuration.setAllowedMethods(Arrays.asList("GET", "POST", "PUT", "PATCH", "DELETE", "OPTIONS"));
        configuration.setAllowedHeaders(Arrays.asList("Authorization", "Content-Type", "X-API-Key", "X-Requested-With", "Accept", "Origin"));
        configuration.setExposedHeaders(Arrays.asList("Authorization", "Content-Type"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setMaxAge(Long.valueOf(3600L));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Bean
    @Order(value=2)
    public SecurityFilterChain apiSecurityFilterChain(HttpSecurity http, ApiKeyAuthFilter apiKeyAuthFilter, Nip98AuthFilter nip98AuthFilter, HmacSignatureFilter hmacSignatureFilter, RateLimitFilter rateLimitFilter, CorsConfigurationSource corsConfigurationSource) throws Exception {
        http.securityMatcher(new String[]{"/api/**", "/health", "/ready", "/metrics", "/openapi", "/swagger-ui/**", "/actuator/**"}).cors(cors -> cors.configurationSource(corsConfigurationSource)).csrf(csrf -> csrf.disable()).sessionManagement(sm -> sm.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/health", "/ready", "/metrics", "/openapi", "/swagger-ui/**", "/actuator/health", "/actuator/info", "/api/v1/webhooks/event-types", "/api/v1/profiles/payment-methods"})).permitAll().requestMatchers(new String[]{"/api/v1/profiles/**"})).permitAll().anyRequest()).authenticated()).addFilterBefore((Filter)nip98AuthFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)apiKeyAuthFilter, Nip98AuthFilter.class).addFilterAfter((Filter)hmacSignatureFilter, ApiKeyAuthFilter.class).addFilterAfter((Filter)rateLimitFilter, HmacSignatureFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=3)
    public SecurityFilterChain webFallbackSecurityFilterChain(HttpSecurity http, CorsConfigurationSource corsConfigurationSource) throws Exception {
        http.cors(cors -> cors.configurationSource(corsConfigurationSource)).csrf(csrf -> csrf.disable()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/login", "/register", "/logout", "/css/**", "/js/**", "/images/**", "/error"})).permitAll().requestMatchers(new String[]{"/web/**"})).authenticated().anyRequest()).permitAll()).formLogin(form -> ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)form.loginPage("/login").loginProcessingUrl("/login")).defaultSuccessUrl("/web/dashboard", true)).failureUrl("/login?error=true")).usernameParameter("email").passwordParameter("password").permitAll()).logout(logout -> logout.logoutUrl("/logout").logoutSuccessUrl("/login?logout=true").permitAll());
        return (SecurityFilterChain)http.build();
    }
}

