/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import java.time.Duration;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import xyz.tcheeric.gateway.api.service.voucher.VoucherBackingConfig;

@ConfigurationProperties(prefix="gateway.wallet")
public class GatewayWalletProperties {
    private boolean enabled = false;
    private Mint mint = new Mint();
    private Database database = new Database();
    private CircuitBreaker circuitBreaker = new CircuitBreaker();
    private Voucher voucher = new Voucher();
    private Nostr nostr = new Nostr();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Mint getMint() {
        return this.mint;
    }

    public void setMint(Mint mint) {
        this.mint = mint;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public Voucher getVoucher() {
        return this.voucher;
    }

    public void setVoucher(Voucher voucher) {
        this.voucher = voucher;
    }

    public Nostr getNostr() {
        return this.nostr;
    }

    public void setNostr(Nostr nostr) {
        this.nostr = nostr;
    }

    public static class Mint {
        private String url = "http://localhost:7777";
        private Duration connectTimeout = Duration.ofSeconds(10L);
        private Duration readTimeout = Duration.ofSeconds(30L);

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }
    }

    public static class Database {
        private String url = "jdbc:h2:mem:wallet;DB_CLOSE_DELAY=-1";
        private String username = "sa";
        private String password = "";
        private String driverClassName = "org.h2.Driver";
        private int maximumPoolSize = 5;
        private Duration connectionTimeout = Duration.ofSeconds(30L);

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public void setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
        }

        public int getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }
    }

    public static class CircuitBreaker {
        private boolean enabled = true;
        private float failureRateThreshold = 50.0f;
        private int slidingWindowSize = 20;
        private int permittedCallsInHalfOpen = 3;
        private Duration waitDurationInOpenState = Duration.ofSeconds(10L);
        private float slowCallRateThreshold = 100.0f;
        private Duration slowCallDurationThreshold = Duration.ofSeconds(5L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public float getFailureRateThreshold() {
            return this.failureRateThreshold;
        }

        public void setFailureRateThreshold(float failureRateThreshold) {
            this.failureRateThreshold = failureRateThreshold;
        }

        public int getSlidingWindowSize() {
            return this.slidingWindowSize;
        }

        public void setSlidingWindowSize(int slidingWindowSize) {
            this.slidingWindowSize = slidingWindowSize;
        }

        public int getPermittedCallsInHalfOpen() {
            return this.permittedCallsInHalfOpen;
        }

        public void setPermittedCallsInHalfOpen(int permittedCallsInHalfOpen) {
            this.permittedCallsInHalfOpen = permittedCallsInHalfOpen;
        }

        public Duration getWaitDurationInOpenState() {
            return this.waitDurationInOpenState;
        }

        public void setWaitDurationInOpenState(Duration waitDurationInOpenState) {
            this.waitDurationInOpenState = waitDurationInOpenState;
        }

        public float getSlowCallRateThreshold() {
            return this.slowCallRateThreshold;
        }

        public void setSlowCallRateThreshold(float slowCallRateThreshold) {
            this.slowCallRateThreshold = slowCallRateThreshold;
        }

        public Duration getSlowCallDurationThreshold() {
            return this.slowCallDurationThreshold;
        }

        public void setSlowCallDurationThreshold(Duration slowCallDurationThreshold) {
            this.slowCallDurationThreshold = slowCallDurationThreshold;
        }
    }

    public static class Voucher
    implements VoucherBackingConfig {
        private String backupMode = "local";
        private long fixedBackingSats = 1L;
        private long minimalBackingSats = 10L;
        private int satsPerMinorUnit = 1;
        private RoundingMode roundingMode = RoundingMode.FLOOR;
        private double platformFeeRate = 0.025;
        private boolean autopay = true;
        @Deprecated(since="5.10", forRemoval=true)
        private double discountRate = 0.0;
        @Deprecated(since="5.10", forRemoval=true)
        private double platformFee = 0.0;

        public String getBackupMode() {
            return this.backupMode;
        }

        public void setBackupMode(String backupMode) {
            if (backupMode != null && !backupMode.equals("local") && !backupMode.equals("nostr")) {
                throw new IllegalArgumentException("backupMode must be 'local' or 'nostr'");
            }
            this.backupMode = backupMode != null ? backupMode : "local";
        }

        public long getFixedBackingSats() {
            return this.fixedBackingSats;
        }

        public void setFixedBackingSats(long fixedBackingSats) {
            if (fixedBackingSats < 1L) {
                throw new IllegalArgumentException("fixedBackingSats must be at least 1");
            }
            this.fixedBackingSats = fixedBackingSats;
        }

        public long getMinimalBackingSats() {
            return this.minimalBackingSats;
        }

        public void setMinimalBackingSats(long minimalBackingSats) {
            if (minimalBackingSats < 1L) {
                throw new IllegalArgumentException("minimalBackingSats must be at least 1");
            }
            this.minimalBackingSats = minimalBackingSats;
        }

        public int getSatsPerMinorUnit() {
            return this.satsPerMinorUnit;
        }

        public void setSatsPerMinorUnit(int satsPerMinorUnit) {
            if (satsPerMinorUnit < 1) {
                throw new IllegalArgumentException("satsPerMinorUnit must be at least 1");
            }
            this.satsPerMinorUnit = satsPerMinorUnit;
        }

        public RoundingMode getInternalRoundingMode() {
            return this.roundingMode;
        }

        public VoucherBackingConfig.RoundingMode getRoundingMode() {
            return this.roundingMode.toApiRoundingMode();
        }

        public void setRoundingMode(RoundingMode roundingMode) {
            this.roundingMode = roundingMode != null ? roundingMode : RoundingMode.FLOOR;
        }

        public double getPlatformFeeRate() {
            return this.platformFeeRate;
        }

        public void setPlatformFeeRate(double platformFeeRate) {
            if (platformFeeRate < 0.0 || platformFeeRate > 1.0) {
                throw new IllegalArgumentException("platformFeeRate must be between 0.0 and 1.0");
            }
            this.platformFeeRate = platformFeeRate;
        }

        public boolean isAutopay() {
            return this.autopay;
        }

        public void setAutopay(boolean autopay) {
            this.autopay = autopay;
        }

        @Deprecated(since="5.10", forRemoval=true)
        public double getDiscountRate() {
            return this.discountRate;
        }

        @Deprecated(since="5.10", forRemoval=true)
        public void setDiscountRate(double discountRate) {
            if (discountRate < 0.0 || discountRate > 1.0) {
                throw new IllegalArgumentException("discountRate must be between 0.0 and 1.0");
            }
            this.discountRate = discountRate;
        }

        @Deprecated(since="5.10", forRemoval=true)
        public double getPlatformFee() {
            return this.platformFee;
        }

        @Deprecated(since="5.10", forRemoval=true)
        public void setPlatformFee(double platformFee) {
            if (platformFee < 0.0 || platformFee > 1.0) {
                throw new IllegalArgumentException("platformFee must be between 0.0 and 1.0");
            }
            this.platformFee = platformFee;
        }

        public long calculateCostWithFee(long tokenAmount) {
            double fee = (double)tokenAmount * this.platformFeeRate;
            return tokenAmount + Math.round(fee);
        }

        public long calculatePlatformFee(long tokenAmount) {
            return Math.round((double)tokenAmount * this.platformFeeRate);
        }

        @Deprecated(since="5.10", forRemoval=true)
        public long calculateCost(long faceValue) {
            double baseCost = (double)faceValue * (1.0 - this.discountRate);
            double totalCost = baseCost * (1.0 + this.platformFee);
            return Math.round(totalCost);
        }

        @Deprecated(since="5.10", forRemoval=true)
        public long calculatePlatformContribution(long faceValue) {
            return Math.round((double)faceValue * this.discountRate);
        }

        public static enum RoundingMode {
            FLOOR,
            CEIL,
            ROUND;


            public VoucherBackingConfig.RoundingMode toApiRoundingMode() {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> VoucherBackingConfig.RoundingMode.FLOOR;
                    case 1 -> VoucherBackingConfig.RoundingMode.CEIL;
                    case 2 -> VoucherBackingConfig.RoundingMode.ROUND;
                };
            }
        }
    }

    public static class Nostr {
        private List<String> relays = List.of();
        private int syncInterval = 3600;
        private boolean autoSync = false;
        private String nutzapPubkey;
        private boolean autoRedeem = false;
        private List<String> preferredMints = List.of();

        public List<String> getRelays() {
            return this.relays;
        }

        public void setRelays(List<String> relays) {
            this.relays = relays != null ? relays : List.of();
        }

        public int getSyncInterval() {
            return this.syncInterval;
        }

        public void setSyncInterval(int syncInterval) {
            this.syncInterval = syncInterval;
        }

        public boolean isAutoSync() {
            return this.autoSync;
        }

        public void setAutoSync(boolean autoSync) {
            this.autoSync = autoSync;
        }

        public String getNutzapPubkey() {
            return this.nutzapPubkey;
        }

        public void setNutzapPubkey(String nutzapPubkey) {
            this.nutzapPubkey = nutzapPubkey;
        }

        public boolean isAutoRedeem() {
            return this.autoRedeem;
        }

        public void setAutoRedeem(boolean autoRedeem) {
            this.autoRedeem = autoRedeem;
        }

        public List<String> getPreferredMints() {
            return this.preferredMints;
        }

        public void setPreferredMints(List<String> preferredMints) {
            this.preferredMints = preferredMints != null ? preferredMints : List.of();
        }
    }
}

