/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import xyz.tcheeric.gateway.api.dto.mint.AddMintRequest;
import xyz.tcheeric.gateway.api.dto.mint.MintInfoResponse;
import xyz.tcheeric.gateway.api.dto.sync.NutzapInfoRequest;
import xyz.tcheeric.gateway.api.dto.sync.NutzapInfoResponse;
import xyz.tcheeric.gateway.api.dto.sync.NutzapListResponse;
import xyz.tcheeric.gateway.api.dto.sync.NutzapResponse;
import xyz.tcheeric.gateway.api.dto.sync.RestoreSnapshotRequest;
import xyz.tcheeric.gateway.api.dto.sync.RestoreSnapshotResponse;
import xyz.tcheeric.gateway.api.dto.sync.SendNutzapRequest;
import xyz.tcheeric.gateway.api.dto.sync.WalletSnapshotRequest;
import xyz.tcheeric.gateway.api.dto.sync.WalletSnapshotResponse;
import xyz.tcheeric.gateway.api.dto.sync.WalletSyncStatusResponse;
import xyz.tcheeric.gateway.api.dto.transaction.TransactionFilter;
import xyz.tcheeric.gateway.api.dto.transaction.TransactionResponse;
import xyz.tcheeric.gateway.api.dto.voucher.BackingStrategy;
import xyz.tcheeric.gateway.api.dto.voucher.CreateVoucherRequest;
import xyz.tcheeric.gateway.api.dto.voucher.PaymentStatusResponse;
import xyz.tcheeric.gateway.api.dto.voucher.VoucherResponse;
import xyz.tcheeric.gateway.api.dto.voucher.VoucherSplitPreviewRequest;
import xyz.tcheeric.gateway.api.dto.voucher.VoucherSplitPreviewResponse;
import xyz.tcheeric.gateway.api.dto.voucher.VoucherSplitRequest;
import xyz.tcheeric.gateway.api.dto.voucher.VoucherSplitResponse;
import xyz.tcheeric.gateway.api.dto.wallet.BalanceResponse;
import xyz.tcheeric.gateway.api.dto.wallet.MeltRequest;
import xyz.tcheeric.gateway.api.dto.wallet.MeltResponse;
import xyz.tcheeric.gateway.api.dto.wallet.MintQuoteRequest;
import xyz.tcheeric.gateway.api.dto.wallet.MintQuoteResponse;
import xyz.tcheeric.gateway.api.dto.wallet.MintTokensResponse;
import xyz.tcheeric.gateway.api.dto.wallet.ReceiveRequest;
import xyz.tcheeric.gateway.api.dto.wallet.ReceiveResponse;
import xyz.tcheeric.gateway.api.dto.wallet.SendRequest;
import xyz.tcheeric.gateway.api.dto.wallet.SendResponse;
import xyz.tcheeric.gateway.api.port.NutzapPort;
import xyz.tcheeric.gateway.api.port.WalletPort;
import xyz.tcheeric.gateway.api.port.WalletSyncPort;
import xyz.tcheeric.gateway.app.config.GatewayWalletProperties;

@Configuration
@EnableConfigurationProperties(value={GatewayWalletProperties.class})
public class StubWalletConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(StubWalletConfiguration.class);

    @Bean
    @ConditionalOnProperty(name={"gateway.wallet.enabled"}, havingValue="false", matchIfMissing=true)
    WalletPort stubWalletPort(GatewayWalletProperties properties) {
        GatewayWalletProperties.Voucher voucherConfig = properties.getVoucher();
        LOGGER.info("wallet_stub_enabled reason=no_other_wallet_port_bean_exists fixed_backing_sats={} minimal_backing_sats={} sats_per_minor_unit={} platform_fee_rate={}", new Object[]{voucherConfig.getFixedBackingSats(), voucherConfig.getMinimalBackingSats(), voucherConfig.getSatsPerMinorUnit(), voucherConfig.getPlatformFeeRate()});
        return new StubWalletPort(voucherConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={NutzapPort.class})
    NutzapPort stubNutzapPort() {
        LOGGER.info("nutzap_stub_enabled reason=no_nutzap_port_bean_available");
        return new StubNutzapPort();
    }

    @Bean
    @ConditionalOnMissingBean(value={WalletSyncPort.class})
    WalletSyncPort stubWalletSyncPort() {
        LOGGER.info("wallet_sync_stub_enabled reason=no_wallet_sync_port_bean_available");
        return new StubWalletSyncPort();
    }

    private static class StubWalletPort
    implements WalletPort {
        private static final Logger LOGGER = LoggerFactory.getLogger(StubWalletPort.class);
        private static final AtomicLong VOUCHER_SEQUENCE = new AtomicLong(0L);
        private final Map<String, StubVoucher> vouchers = new ConcurrentHashMap<String, StubVoucher>();
        private final GatewayWalletProperties.Voucher voucherConfig;

        StubWalletPort(GatewayWalletProperties.Voucher voucherConfig) {
            this.voucherConfig = voucherConfig;
        }

        public BalanceResponse getBalance(String unit, String mintUrl) {
            LOGGER.debug("wallet_stub_get_balance unit={} mint_url={}", (Object)unit, (Object)mintUrl);
            return new BalanceResponse(Map.of(), List.of(), 0, Instant.now());
        }

        public MintQuoteResponse createMintQuote(MintQuoteRequest request) {
            LOGGER.warn("wallet_stub_create_mint_quote_not_supported");
            throw new WalletPort.WalletOperationException("Wallet services not configured. Set gateway.wallet.enabled=true");
        }

        public MintQuoteResponse getMintQuote(String quoteId) {
            LOGGER.warn("wallet_stub_get_mint_quote_not_supported");
            throw new WalletPort.QuoteNotFoundException(quoteId);
        }

        public MintTokensResponse mintTokens(String quoteId) {
            LOGGER.warn("wallet_stub_mint_tokens_not_supported");
            throw new WalletPort.WalletOperationException("Wallet services not configured. Set gateway.wallet.enabled=true");
        }

        public SendResponse send(SendRequest request) {
            LOGGER.warn("wallet_stub_send_not_supported");
            throw new WalletPort.WalletOperationException("Wallet services not configured. Set gateway.wallet.enabled=true");
        }

        public ReceiveResponse receive(ReceiveRequest request) {
            LOGGER.warn("wallet_stub_receive_not_supported");
            throw new WalletPort.WalletOperationException("Wallet services not configured. Set gateway.wallet.enabled=true");
        }

        public MeltResponse melt(MeltRequest request) {
            LOGGER.warn("wallet_stub_melt_not_supported");
            throw new WalletPort.WalletOperationException("Wallet services not configured. Set gateway.wallet.enabled=true");
        }

        public List<VoucherResponse> listVouchers(String status, int page, int pageSize) {
            LOGGER.debug("wallet_stub_list_vouchers status={} page={} page_size={}", new Object[]{status, page, pageSize});
            return this.vouchers.values().stream().filter(voucher -> status == null || status.equalsIgnoreCase(voucher.status())).sorted((a, b) -> a.issuedAt().compareTo(b.issuedAt())).skip((long)(page - 1) * (long)pageSize).limit(pageSize).map(this::toResponse).toList();
        }

        public VoucherResponse createVoucher(CreateVoucherRequest request) {
            String voucherId = "v-" + VOUCHER_SEQUENCE.incrementAndGet();
            Instant issuedAt = Instant.now();
            Instant expiresAt = request.expiresInDays() != null ? issuedAt.plus((long)request.expiresInDays().intValue(), ChronoUnit.DAYS) : null;
            BackingStrategy strategy = request.backingStrategy() != null ? request.backingStrategy() : BackingStrategy.MINIMAL;
            long tokenAmount = this.calculateTokenAmount(strategy, request.faceValue(), request.getEffectiveFaceDecimals());
            double issuanceRatio = tokenAmount > 0L ? (double)request.faceValue().longValue() / (double)tokenAmount : 0.0;
            StubVoucher voucher = new StubVoucher(voucherId, request.faceValue(), request.getEffectiveUnit(), request.getEffectiveFaceDecimals(), strategy, tokenAmount, issuanceRatio, request.issuerId(), request.memo(), request.merchantMetadata(), issuedAt, expiresAt, null, "ISSUED");
            this.vouchers.put(voucherId, voucher);
            String mockToken = "cashuA" + Base64.getEncoder().encodeToString(("stub_token_" + voucherId + "_" + tokenAmount).getBytes());
            LOGGER.info("wallet_stub_voucher_created voucher_id={} face_value={} unit={} backing_strategy={} token_amount={} issuance_ratio={}", new Object[]{voucherId, request.faceValue(), request.getEffectiveUnit(), strategy, tokenAmount, issuanceRatio});
            return this.toResponseWithToken(voucher, mockToken);
        }

        private long calculateTokenAmount(BackingStrategy strategy, long faceValue, int faceDecimals) {
            return switch (strategy) {
                default -> throw new MatchException(null, null);
                case BackingStrategy.FIXED -> this.voucherConfig.getFixedBackingSats();
                case BackingStrategy.MINIMAL -> this.voucherConfig.getMinimalBackingSats();
                case BackingStrategy.PROPORTIONAL -> {
                    long minorUnits = faceDecimals > 0 ? faceValue : faceValue;
                    yield minorUnits * (long)this.voucherConfig.getSatsPerMinorUnit();
                }
            };
        }

        public Optional<VoucherResponse> getVoucher(String voucherId) {
            LOGGER.debug("wallet_stub_get_voucher voucher_id={}", (Object)voucherId);
            return Optional.ofNullable(this.vouchers.get(voucherId)).map(this::toResponse);
        }

        public VoucherResponse redeemVoucher(String voucherId, String redeemerId) {
            LOGGER.info("wallet_stub_redeem_voucher voucher_id={} redeemer_id={}", (Object)voucherId, (Object)redeemerId);
            StubVoucher voucher = this.vouchers.get(voucherId);
            if (voucher == null) {
                throw new WalletPort.VoucherNotFoundException(voucherId);
            }
            if (!"ISSUED".equalsIgnoreCase(voucher.status())) {
                throw new WalletPort.VoucherNotRedeemableException(voucherId, "already redeemed or revoked");
            }
            StubVoucher redeemed = voucher.redeemed(Instant.now());
            this.vouchers.put(voucherId, redeemed);
            return this.toResponse(redeemed);
        }

        public VoucherResponse revokeVoucher(String voucherId, String reason) {
            LOGGER.info("wallet_stub_revoke_voucher voucher_id={} reason={}", (Object)voucherId, (Object)reason);
            StubVoucher voucher = this.vouchers.get(voucherId);
            if (voucher == null) {
                throw new WalletPort.VoucherNotFoundException(voucherId);
            }
            if (!"ISSUED".equalsIgnoreCase(voucher.status())) {
                throw new WalletPort.VoucherNotRevocableException(voucherId, "already redeemed or revoked");
            }
            StubVoucher revoked = voucher.revoked(reason);
            this.vouchers.put(voucherId, revoked);
            return this.toResponse(revoked);
        }

        public PaymentStatusResponse getVoucherPaymentStatus(String voucherId) {
            LOGGER.debug("wallet_stub_get_voucher_payment_status voucher_id={}", (Object)voucherId);
            StubVoucher voucher = this.vouchers.get(voucherId);
            if (voucher == null) {
                throw new WalletPort.VoucherNotFoundException(voucherId);
            }
            String paymentState = switch (voucher.status().toUpperCase()) {
                case "ISSUED", "REDEEMED" -> "CONFIRMED";
                case "PENDING", "AWAITING_PAYMENT", "CREATED" -> "PENDING";
                case "EXPIRED" -> "EXPIRED";
                case "REVOKED" -> "FAILED";
                default -> "PENDING";
            };
            return PaymentStatusResponse.builder().voucherId(voucherId).paymentState(paymentState).amountSat(Long.valueOf(voucher.faceValue())).build();
        }

        public VoucherSplitPreviewResponse previewVoucherSplit(VoucherSplitPreviewRequest request) {
            LOGGER.warn("wallet_stub_preview_split_not_supported");
            throw new WalletPort.WalletOperationException("Voucher split preview not available. Reason: wallet stub mode. Suggestion: enable gateway wallet integration.");
        }

        public VoucherSplitResponse executeVoucherSplit(VoucherSplitRequest request) {
            LOGGER.warn("wallet_stub_execute_split_not_supported");
            throw new WalletPort.WalletOperationException("Voucher split execution not available. Reason: wallet stub mode. Suggestion: enable gateway wallet integration.");
        }

        public WalletPort.TransactionQueryResult listTransactions(TransactionFilter filter) {
            LOGGER.debug("wallet_stub_list_transactions");
            return new WalletPort.TransactionQueryResult(List.of(), 0, filter.limit().intValue(), filter.offset().intValue());
        }

        public Optional<TransactionResponse> getTransaction(String transactionId) {
            LOGGER.debug("wallet_stub_get_transaction transaction_id={}", (Object)transactionId);
            return Optional.empty();
        }

        public String exportTransactions(String format, TransactionFilter filter) {
            LOGGER.debug("wallet_stub_export_transactions format={}", (Object)format);
            return "csv".equalsIgnoreCase(format) ? "" : "[]";
        }

        public List<MintInfoResponse> listMints() {
            LOGGER.debug("wallet_stub_list_mints");
            return List.of();
        }

        public MintInfoResponse addMint(AddMintRequest request) {
            LOGGER.warn("wallet_stub_add_mint_not_supported");
            throw new WalletPort.WalletOperationException("Wallet services not configured. Set gateway.wallet.enabled=true");
        }

        public Optional<MintInfoResponse> getMintInfo(String mintUrl) {
            LOGGER.debug("wallet_stub_get_mint_info mint_url={}", (Object)mintUrl);
            return Optional.empty();
        }

        public void removeMint(String mintUrl) {
            LOGGER.warn("wallet_stub_remove_mint_not_supported");
            throw new WalletPort.WalletOperationException("Wallet services not configured. Set gateway.wallet.enabled=true");
        }

        private VoucherResponse toResponse(StubVoucher voucher) {
            return this.toResponseWithToken(voucher, null);
        }

        private VoucherResponse toResponseWithToken(StubVoucher voucher, String token) {
            long tokenAmount = voucher.tokenAmount();
            long cost = this.voucherConfig.calculateCostWithFee(tokenAmount);
            long fee = this.voucherConfig.calculatePlatformFee(tokenAmount);
            String displayFaceValue = this.formatDisplayFaceValue(voucher.faceValue(), voucher.faceUnit(), voucher.faceDecimals());
            return VoucherResponse.builder().voucherId(voucher.voucherId()).faceValue(voucher.faceValue()).faceUnit(voucher.faceUnit()).faceDecimals(Integer.valueOf(voucher.faceDecimals())).displayFaceValue(displayFaceValue).backingStrategy(voucher.backingStrategy()).tokenAmount(Long.valueOf(tokenAmount)).tokenUnit("sat").issuanceRatio(Double.valueOf(voucher.issuanceRatio())).cost(Long.valueOf(cost)).fee(Long.valueOf(fee)).issuerId(voucher.issuerId()).status(voucher.status()).memo(voucher.memo()).merchantMetadata(voucher.merchantMetadata()).issuedAt(voucher.issuedAt()).expiresAt(voucher.expiresAt()).redeemedAt(voucher.redeemedAt()).token(token).build();
        }

        private String formatDisplayFaceValue(long faceValue, String faceUnit, int faceDecimals) {
            if (faceDecimals == 0) {
                return faceValue + " " + faceUnit;
            }
            double divisor = Math.pow(10.0, faceDecimals);
            double displayValue = (double)faceValue / divisor;
            String currencySymbol = this.getCurrencySymbol(faceUnit);
            return String.format("%s%.2f", currencySymbol, displayValue);
        }

        private String getCurrencySymbol(String unit) {
            if (unit == null) {
                return "";
            }
            return switch (unit.toUpperCase()) {
                case "EUR" -> "\u20ac";
                case "USD" -> "$";
                case "GBP" -> "\u00a3";
                case "SAT", "SATS" -> "";
                default -> unit + " ";
            };
        }

        private record StubVoucher(String voucherId, long faceValue, String faceUnit, int faceDecimals, BackingStrategy backingStrategy, long tokenAmount, double issuanceRatio, String issuerId, String memo, Map<String, Object> merchantMetadata, Instant issuedAt, Instant expiresAt, Instant redeemedAt, String status) {
            StubVoucher redeemed(Instant redeemedAt) {
                return new StubVoucher(this.voucherId, this.faceValue, this.faceUnit, this.faceDecimals, this.backingStrategy, this.tokenAmount, this.issuanceRatio, this.issuerId, this.memo, this.merchantMetadata, this.issuedAt, this.expiresAt, redeemedAt, "REDEEMED");
            }

            StubVoucher revoked(String reason) {
                return new StubVoucher(this.voucherId, this.faceValue, this.faceUnit, this.faceDecimals, this.backingStrategy, this.tokenAmount, this.issuanceRatio, this.issuerId, this.memo, this.merchantMetadata, this.issuedAt, this.expiresAt, this.redeemedAt, "REVOKED");
            }
        }
    }

    private static class StubNutzapPort
    implements NutzapPort {
        private static final Logger LOGGER = LoggerFactory.getLogger(StubNutzapPort.class);
        private boolean autoRedeemEnabled = false;

        private StubNutzapPort() {
        }

        public Optional<NutzapInfoResponse> getNutzapInfo() {
            LOGGER.debug("nutzap_stub get_nutzap_info");
            return Optional.empty();
        }

        public Optional<NutzapInfoResponse> getNutzapInfo(String pubkey, List<String> relayUrls) {
            LOGGER.debug("nutzap_stub get_nutzap_info pubkey={}", (Object)pubkey);
            return Optional.empty();
        }

        public NutzapInfoResponse publishNutzapInfo(NutzapInfoRequest request) {
            LOGGER.warn("nutzap_stub publish_nutzap_info_not_supported");
            throw new WalletPort.WalletOperationException("Nutzap services not configured. Set gateway.wallet.enabled=true");
        }

        public NutzapResponse sendNutzap(SendNutzapRequest request) {
            LOGGER.warn("nutzap_stub send_nutzap_not_supported");
            throw new WalletPort.WalletOperationException("Nutzap services not configured. Set gateway.wallet.enabled=true");
        }

        public NutzapListResponse listReceivedNutzaps(String status, Long minAmount, Long maxAmount, int limit, int offset) {
            LOGGER.debug("nutzap_stub list_received_nutzaps");
            return new NutzapListResponse(List.of(), 0, limit, offset, false);
        }

        public Optional<NutzapResponse> getNutzap(String nutzapId) {
            LOGGER.debug("nutzap_stub get_nutzap nutzap_id={}", (Object)nutzapId);
            return Optional.empty();
        }

        public Optional<NutzapResponse> getNutzapByEventId(String eventId) {
            LOGGER.debug("nutzap_stub get_nutzap_by_event_id event_id={}", (Object)eventId);
            return Optional.empty();
        }

        public NutzapResponse redeemNutzap(String nutzapId) {
            LOGGER.warn("nutzap_stub redeem_nutzap_not_supported");
            throw new NutzapPort.NutzapNotFoundException(nutzapId);
        }

        public List<NutzapResponse> redeemAllPending() {
            LOGGER.debug("nutzap_stub redeem_all_pending");
            return List.of();
        }

        public void setAutoRedeem(boolean enabled) {
            LOGGER.info("nutzap_stub set_auto_redeem enabled={}", (Object)enabled);
            this.autoRedeemEnabled = enabled;
        }

        public boolean isAutoRedeemEnabled() {
            return this.autoRedeemEnabled;
        }
    }

    private static class StubWalletSyncPort
    implements WalletSyncPort {
        private static final Logger LOGGER = LoggerFactory.getLogger(StubWalletSyncPort.class);
        private boolean autoSyncEnabled = false;

        private StubWalletSyncPort() {
        }

        public WalletSnapshotResponse publishSnapshot(WalletSnapshotRequest request) {
            LOGGER.warn("wallet_sync_stub publish_snapshot_not_supported");
            throw new WalletPort.WalletOperationException("Wallet sync services not configured. Set gateway.wallet.enabled=true");
        }

        public Optional<WalletSnapshotResponse> getLatestSnapshot(String identifier, List<String> relayUrls) {
            LOGGER.debug("wallet_sync_stub get_latest_snapshot identifier={}", (Object)identifier);
            return Optional.empty();
        }

        public List<WalletSnapshotResponse> listSnapshots(String authorPubkey, String identifier, int limit) {
            LOGGER.debug("wallet_sync_stub list_snapshots");
            return List.of();
        }

        public RestoreSnapshotResponse restoreFromSnapshot(RestoreSnapshotRequest request) {
            LOGGER.warn("wallet_sync_stub restore_from_snapshot_not_supported");
            throw new WalletPort.WalletOperationException("Wallet sync services not configured. Set gateway.wallet.enabled=true");
        }

        public WalletSyncStatusResponse getSyncStatus() {
            LOGGER.debug("wallet_sync_stub get_sync_status");
            return WalletSyncStatusResponse.builder().enabled(false).autoSync(this.autoSyncEnabled).configuredRelays(List.of()).connectedRelays(List.of()).build();
        }

        public WalletSyncStatusResponse setAutoSync(boolean enabled) {
            LOGGER.info("wallet_sync_stub set_auto_sync enabled={}", (Object)enabled);
            this.autoSyncEnabled = enabled;
            return WalletSyncStatusResponse.builder().enabled(false).autoSync(this.autoSyncEnabled).configuredRelays(List.of()).connectedRelays(List.of()).build();
        }

        public WalletSyncStatusResponse triggerSync() {
            LOGGER.warn("wallet_sync_stub trigger_sync_not_supported");
            throw new WalletPort.WalletOperationException("Wallet sync services not configured. Set gateway.wallet.enabled=true");
        }
    }
}

