/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import xyz.tcheeric.gateway.api.port.WalletPort;
import xyz.tcheeric.gateway.api.service.voucher.TokenBackingCalculator;
import xyz.tcheeric.gateway.api.service.voucher.VoucherBackingConfig;
import xyz.tcheeric.gateway.app.config.GatewayWalletProperties;
import xyz.tcheeric.gateway.app.config.LocalVoucherBackupService;
import xyz.tcheeric.gateway.rest.adapter.WalletPluginAdapter;
import xyz.tcheeric.wallet.core.DatabaseMigrator;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.H2WalletStorageAdapter;
import xyz.tcheeric.wallet.core.SendService;
import xyz.tcheeric.wallet.core.VoucherBackupService;
import xyz.tcheeric.wallet.core.VoucherBackupServiceImpl;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.VoucherServiceImpl;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.WalletDatabaseConfig;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.adapter.CashuWalletMintApi;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateConfig;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateFactory;
import xyz.tcheeric.wallet.core.crypto.BDHKECryptoAdapter;
import xyz.tcheeric.wallet.core.crypto.CryptoAdapter;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayConfig;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.NostrRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClientFactory;
import xyz.tcheeric.wallet.core.nostr.dm.DmCrypto44;
import xyz.tcheeric.wallet.core.nostr.dm.DmService;
import xyz.tcheeric.wallet.core.nostr.dm.DmServiceNip44;
import xyz.tcheeric.wallet.core.nostr.dm.GatewayDmAdapter;
import xyz.tcheeric.wallet.core.nostr.dm.NostrDmGateway;
import xyz.tcheeric.wallet.core.ports.WalletStorage;
import xyz.tcheeric.wallet.core.security.EncryptionService;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;
import xyz.tcheeric.wallet.core.token.TokenCodec;
import xyz.tcheeric.wallet.core.token.TokenV4Codec;
import xyz.tcheeric.wallet.infra.nip44.DmCryptoNip44;

@Configuration
@ConditionalOnClass(name={"xyz.tcheeric.wallet.core.H2WalletService"})
@ConditionalOnProperty(name={"gateway.wallet.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={GatewayWalletProperties.class})
public class WalletConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(WalletConfiguration.class);

    @Bean
    TokenCodec tokenCodec() {
        LOGGER.info("wallet_token_codec_created type=TokenV4Codec");
        return new TokenV4Codec();
    }

    @Bean
    CryptoAdapter cryptoAdapter() {
        LOGGER.info("wallet_crypto_adapter_created type=BDHKECryptoAdapter");
        return new BDHKECryptoAdapter();
    }

    @Bean
    WalletDatabaseConfig walletDatabaseConfig(GatewayWalletProperties properties) {
        GatewayWalletProperties.Database db = properties.getDatabase();
        LOGGER.info("wallet_database_config_created url={} user={}", (Object)db.getUrl(), (Object)db.getUsername());
        return WalletDatabaseConfig.of((String)db.getUrl(), (String)db.getUsername(), (String)db.getPassword());
    }

    @Bean
    RestTemplate walletRestTemplate(GatewayWalletProperties properties) {
        GatewayWalletProperties.Mint mint = properties.getMint();
        RestTemplateConfig config = RestTemplateConfig.builder().connectTimeout(mint.getConnectTimeout()).readTimeout(mint.getReadTimeout()).enableLogging(true).build();
        LOGGER.info("wallet_rest_template_created connect_timeout={} read_timeout={}", (Object)mint.getConnectTimeout(), (Object)mint.getReadTimeout());
        return RestTemplateFactory.create((RestTemplateConfig)config);
    }

    @Bean
    MintApi mintApi(RestTemplate walletRestTemplate) {
        LOGGER.info("wallet_mint_api_created type=CashuWalletMintApi");
        return new CashuWalletMintApi(walletRestTemplate);
    }

    @Bean
    H2WalletService h2WalletService(MintApi mintApi, CryptoAdapter cryptoAdapter, WalletDatabaseConfig walletDatabaseConfig, GatewayWalletProperties properties) {
        LOGGER.info("wallet_database_migration_starting db_url={}", (Object)properties.getDatabase().getUrl());
        new DatabaseMigrator().migrate(walletDatabaseConfig);
        LOGGER.info("wallet_database_migration_completed");
        LOGGER.info("wallet_service_created type=H2WalletService mint_url={} db_url={}", (Object)properties.getMint().getUrl(), (Object)properties.getDatabase().getUrl());
        return new H2WalletService(mintApi, cryptoAdapter, walletDatabaseConfig);
    }

    @Bean
    EncryptionService encryptionService() {
        LOGGER.info("voucher_encryption_service_created type=EncryptionService");
        EncryptionService service = new EncryptionService();
        service.load();
        return service;
    }

    @Bean
    IdentityKeyService identityKeyService() {
        LOGGER.info("voucher_identity_key_service_created type=IdentityKeyService");
        return new IdentityKeyService();
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.wallet.voucher.backup-mode"}, havingValue="local", matchIfMissing=true)
    VoucherBackupService localVoucherBackupService() {
        LOGGER.info("voucher_backup_service_created type=LocalVoucherBackupService mode=local");
        return new LocalVoucherBackupService();
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.wallet.voucher.backup-mode"}, havingValue="nostr")
    WalletKeyManager walletKeyManager(IdentityKeyService identityKeyService) {
        Path walletHome = Path.of(System.getProperty("user.home"), ".cashu", "gateway");
        LOGGER.info("wallet_key_manager_created wallet_home={}", (Object)walletHome);
        return new WalletKeyManager(SecureKeyStore.create((Path)walletHome));
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.wallet.voucher.backup-mode"}, havingValue="nostr")
    NostrGatewayService nostrGatewayService(IdentityKeyService identityKeyService, WalletKeyManager walletKeyManager, GatewayWalletProperties properties) {
        GatewayWalletProperties.Nostr nostrConfig = properties.getNostr();
        List<NostrRelayOption> relayOptions = nostrConfig.getRelays().stream().map(url -> new NostrRelayOption(url, false)).toList();
        LOGGER.info("nostr_gateway_service_created relay_count={} sync_interval={}", (Object)relayOptions.size(), (Object)nostrConfig.getSyncInterval());
        NostrGatewayService service = new NostrGatewayService(() -> new NostrGatewayConfig(relayOptions), identityKeyService, walletKeyManager, (NostrRelayClientFactory)new NostrJavaRelayClientFactory());
        service.start();
        return service;
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.wallet.voucher.backup-mode"}, havingValue="nostr")
    DmCrypto44 dmCrypto44() {
        LOGGER.info("dm_crypto44_created type=DmCryptoNip44");
        return new DmCryptoNip44();
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.wallet.voucher.backup-mode"}, havingValue="nostr")
    DmService dmService(IdentityKeyService identityKeyService, WalletKeyManager walletKeyManager, NostrGatewayService nostrGatewayService, DmCrypto44 dmCrypto44) {
        LOGGER.info("dm_service_created type=DmServiceNip44");
        return new DmServiceNip44(identityKeyService, walletKeyManager, (NostrDmGateway)new GatewayDmAdapter(nostrGatewayService), dmCrypto44);
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.wallet.voucher.backup-mode"}, havingValue="nostr")
    VoucherBackupService nostrVoucherBackupService(DmService dmService, DmCrypto44 dmCrypto44) {
        LOGGER.info("voucher_backup_service_created type=VoucherBackupServiceImpl mode=nostr");
        return new VoucherBackupServiceImpl(dmService, dmCrypto44);
    }

    @Bean
    WalletStorage walletStorage(H2WalletService walletService) {
        LOGGER.info("voucher_wallet_storage_created type=H2WalletStorageAdapter mode=lazy_datasource");
        return new H2WalletStorageAdapter(() -> ((H2WalletService)walletService).getDataSource());
    }

    @Bean
    VoucherService voucherService(WalletStorage walletStorage, H2WalletService walletService, EncryptionService encryptionService, VoucherBackupService voucherBackupService, IdentityKeyService identityKeyService, TokenCodec tokenCodec) {
        LOGGER.info("voucher_service_created type=VoucherServiceImpl");
        return new VoucherServiceImpl(walletStorage, encryptionService, voucherBackupService, identityKeyService, (SendService)walletService, tokenCodec);
    }

    @Bean
    SmartInitializingSingleton voucherServiceInitializer(VoucherService voucherService, GatewayWalletProperties properties) {
        return () -> {
            if (voucherService instanceof VoucherServiceImpl) {
                VoucherServiceImpl impl = (VoucherServiceImpl)voucherService;
                String mintUrl = properties.getMint().getUrl();
                String defaultUnit = "sat";
                WalletConfig walletConfig = new WalletConfig(mintUrl, defaultUnit);
                impl.init(walletConfig);
                LOGGER.info("voucher_service_initialized mint_url={} default_unit={}", (Object)mintUrl, (Object)defaultUnit);
            }
        };
    }

    @Bean
    TokenBackingCalculator tokenBackingCalculator(GatewayWalletProperties properties) {
        GatewayWalletProperties.Voucher voucherConfig = properties.getVoucher();
        LOGGER.info("token_backing_calculator_created fixed_sats={} minimal_sats={} sats_per_minor_unit={} rounding_mode={} platform_fee_rate={}", new Object[]{voucherConfig.getFixedBackingSats(), voucherConfig.getMinimalBackingSats(), voucherConfig.getSatsPerMinorUnit(), voucherConfig.getRoundingMode(), voucherConfig.getPlatformFeeRate()});
        return new TokenBackingCalculator((VoucherBackingConfig)voucherConfig);
    }

    @Bean
    WalletPort walletPluginAdapter(H2WalletService walletService, MintApi mintApi, VoucherService voucherService, TokenCodec tokenCodec, TokenBackingCalculator tokenBackingCalculator, GatewayWalletProperties properties) {
        String defaultMintUrl = properties.getMint().getUrl();
        GatewayWalletProperties.Voucher voucherConfig = properties.getVoucher();
        double discountRate = voucherConfig.getDiscountRate();
        double platformFee = voucherConfig.getPlatformFee();
        LOGGER.info("wallet_adapter_enabled type=WalletPluginAdapter voucher_service=enabled default_mint_url={} backing_calculator=enabled", (Object)defaultMintUrl);
        return new WalletPluginAdapter(walletService, mintApi, voucherService, tokenCodec, tokenBackingCalculator, defaultMintUrl, discountRate, platformFee);
    }
}

