/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import xyz.tcheeric.gateway.api.dto.wallet.BalanceResponse;
import xyz.tcheeric.gateway.api.port.WalletPort;
import xyz.tcheeric.gateway.app.config.GatewayWalletProperties;

@Component
@ConditionalOnClass(name={"xyz.tcheeric.wallet.core.H2WalletService"})
@ConditionalOnProperty(name={"gateway.wallet.enabled"}, havingValue="true")
public class WalletHealthIndicator
implements HealthIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WalletHealthIndicator.class);
    private final WalletPort walletPort;
    private final GatewayWalletProperties properties;

    public WalletHealthIndicator(WalletPort walletPort, GatewayWalletProperties properties) {
        this.walletPort = walletPort;
        this.properties = properties;
    }

    public Health health() {
        try {
            BalanceResponse balance = this.walletPort.getBalance("sat", this.properties.getMint().getUrl());
            return Health.up().withDetail("enabled", (Object)true).withDetail("mintUrl", (Object)this.properties.getMint().getUrl()).withDetail("totalProofs", (Object)balance.totalProofs()).withDetail("queriedAt", (Object)balance.queriedAt().toString()).build();
        }
        catch (Exception e) {
            LOGGER.warn("wallet_health_check_failed error={}", (Object)e.getMessage());
            return Health.down().withDetail("enabled", (Object)true).withDetail("mintUrl", (Object)this.properties.getMint().getUrl()).withDetail("error", (Object)e.getMessage()).build();
        }
    }
}

